/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.atomset;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.Constant;
import fr.lirmm.graphik.integraal.api.core.Literal;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.Substitutions;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import fr.lirmm.graphik.util.stream.CounterIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractAtomSet
implements AtomSet {
    @Override
    public boolean contains(Atom atom) throws AtomSetException {
        CloseableIterator<Atom> it = this.iterator();
        try {
            while (it.hasNext()) {
                Atom a = it.next();
                if (!Objects.equals(atom, a)) continue;
                return true;
            }
        }
        catch (Exception e) {
            throw new AtomSetException(e);
        }
        return false;
    }

    @Override
    public boolean addAll(CloseableIterator<? extends Atom> it) throws AtomSetException {
        boolean isChanged = false;
        try {
            while (it.hasNext()) {
                isChanged = this.add(it.next()) || isChanged;
            }
        }
        catch (Exception e) {
            throw new AtomSetException(e);
        }
        return isChanged;
    }

    @Override
    public boolean addAll(AtomSet atomset) throws AtomSetException {
        return this.addAll(atomset.iterator());
    }

    @Override
    public boolean removeAll(CloseableIterator<? extends Atom> it) throws AtomSetException {
        boolean isChanged = false;
        try {
            while (it.hasNext()) {
                isChanged = this.remove(it.next()) || isChanged;
            }
        }
        catch (Exception e) {
            throw new AtomSetException(e);
        }
        return isChanged;
    }

    @Override
    public boolean remove(Atom atom) throws AtomSetException {
        if (!this.contains(atom)) {
            return false;
        }
        this.removeWithoutCheck(atom);
        return true;
    }

    @Override
    public boolean removeAll(AtomSet atomset) throws AtomSetException {
        return this.removeAll(atomset.iterator());
    }

    @Override
    public CloseableIterator<Atom> match(Atom atom) throws AtomSetException {
        return this.match(atom, Substitutions.emptySubstitution());
    }

    @Override
    public Set<Term> getTerms() throws AtomSetException {
        HashSet<Term> terms = new HashSet<Term>();
        CloseableIterator<Atom> atomIt = this.iterator();
        try {
            while (atomIt.hasNext()) {
                Iterator<Term> termIt = atomIt.next().iterator();
                while (termIt.hasNext()) {
                    terms.add(termIt.next());
                }
            }
        }
        catch (Exception e) {
            throw new AtomSetException(e);
        }
        return terms;
    }

    @Override
    public Set<Variable> getVariables() throws AtomSetException {
        HashSet<Variable> terms = new HashSet<Variable>();
        CloseableIterator<Atom> atomIt = this.iterator();
        try {
            while (atomIt.hasNext()) {
                for (Term t : atomIt.next()) {
                    if (!t.isVariable()) continue;
                    terms.add((Variable)t);
                }
            }
        }
        catch (Exception e) {
            throw new AtomSetException(e);
        }
        return terms;
    }

    @Override
    public Set<Constant> getConstants() throws AtomSetException {
        HashSet<Constant> terms = new HashSet<Constant>();
        CloseableIterator<Atom> atomIt = this.iterator();
        try {
            while (atomIt.hasNext()) {
                for (Term t : atomIt.next()) {
                    if (!t.isConstant()) continue;
                    terms.add((Constant)t);
                }
            }
        }
        catch (Exception e) {
            throw new AtomSetException(e);
        }
        return terms;
    }

    @Override
    public Set<Literal> getLiterals() throws AtomSetException {
        HashSet<Literal> terms = new HashSet<Literal>();
        CloseableIterator<Atom> atomIt = this.iterator();
        try {
            while (atomIt.hasNext()) {
                for (Term t : atomIt.next()) {
                    if (!t.isLiteral()) continue;
                    terms.add((Literal)t);
                }
            }
        }
        catch (Exception e) {
            throw new AtomSetException(e);
        }
        return terms;
    }

    @Override
    public CloseableIterator<Variable> variablesIterator() throws AtomSetException {
        return new CloseableIteratorAdapter<Variable>(this.getVariables().iterator());
    }

    @Override
    public CloseableIterator<Constant> constantsIterator() throws AtomSetException {
        return new CloseableIteratorAdapter<Constant>(this.getConstants().iterator());
    }

    @Override
    public CloseableIterator<Literal> literalsIterator() throws AtomSetException {
        return new CloseableIteratorAdapter<Literal>(this.getLiterals().iterator());
    }

    @Override
    @Deprecated
    public Set<Term> getTerms(Term.Type type) throws AtomSetException {
        HashSet<Term> terms = new HashSet<Term>();
        try {
            CloseableIterator<Term> it = this.termsIterator(type);
            while (it.hasNext()) {
                terms.add(it.next());
            }
        }
        catch (Exception e) {
            throw new AtomSetException(e);
        }
        return terms;
    }

    @Override
    public Set<Predicate> getPredicates() throws AtomSetException {
        HashSet<Predicate> predicates = new HashSet<Predicate>();
        CloseableIterator<Predicate> it = this.predicatesIterator();
        try {
            while (it.hasNext()) {
                predicates.add(it.next());
            }
        }
        catch (Exception e) {
            throw new AtomSetException(e);
        }
        return predicates;
    }

    @Override
    @Deprecated
    public boolean isSubSetOf(AtomSet atomset) throws AtomSetException {
        CloseableIterator<Atom> it = atomset.iterator();
        try {
            while (it.hasNext()) {
                Atom a = it.next();
                if (atomset.contains(a)) continue;
                return false;
            }
        }
        catch (Exception e) {
            throw new AtomSetException(e);
        }
        return true;
    }

    @Override
    public int size() throws AtomSetException {
        CounterIterator<Atom> it = new CounterIterator<Atom>(this.iterator());
        int ret = it.getCptValue();
        it.close();
        return ret;
    }

    @Override
    public boolean isEmpty() throws AtomSetException {
        try {
            return !this.iterator().hasNext();
        }
        catch (Exception e) {
            throw new AtomSetException(e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AtomSet)) {
            return false;
        }
        return this.equals((AtomSet)obj);
    }

    public boolean equals(AtomSet other) {
        try {
            Atom a;
            CloseableIterator<Atom> it = this.iterator();
            while (it.hasNext()) {
                a = it.next();
                if (other.contains(a)) continue;
                return false;
            }
            it = other.iterator();
            while (it.hasNext()) {
                a = it.next();
                if (this.contains(a)) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('[');
        CloseableIterator<Atom> it = this.iterator();
        try {
            if (it.hasNext()) {
                s.append(it.next().toString());
            }
            while (it.hasNext()) {
                s.append(", ");
                s.append(it.next().toString());
            }
        }
        catch (Exception e) {
            s.append("ERROR: " + e.toString());
        }
        s.append(']');
        return s.toString();
    }
}

