/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.atomset;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.TermGenerator;
import fr.lirmm.graphik.integraal.core.AtomType;
import fr.lirmm.graphik.integraal.core.DefaultAtom;
import fr.lirmm.graphik.integraal.core.DefaultVariableGenerator;
import fr.lirmm.graphik.integraal.core.TypeFilter;
import fr.lirmm.graphik.integraal.core.atomset.AbstractInMemoryAtomSet;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import fr.lirmm.graphik.util.stream.CloseableIteratorWithoutException;
import fr.lirmm.graphik.util.stream.IteratorException;
import fr.lirmm.graphik.util.stream.filter.Filter;
import fr.lirmm.graphik.util.stream.filter.FilterIteratorWithoutException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultInMemoryAtomSet
extends AbstractInMemoryAtomSet {
    private Set<Atom> atomSet;
    private TermGenerator freshSymbolGenerator = new DefaultVariableGenerator("EE", this);

    public DefaultInMemoryAtomSet() {
        this.atomSet = new HashSet<Atom>();
    }

    public DefaultInMemoryAtomSet(Set<Atom> javaAtomSet) {
        this.atomSet = javaAtomSet;
    }

    public DefaultInMemoryAtomSet(Collection<Atom> collection) {
        this();
        this.atomSet.addAll(collection);
    }

    public DefaultInMemoryAtomSet(Atom ... atoms) {
        this();
        for (Atom a : atoms) {
            this.atomSet.add(a);
        }
    }

    public DefaultInMemoryAtomSet(CloseableIterator<Atom> it) throws IteratorException {
        this();
        while (it.hasNext()) {
            this.atomSet.add(it.next());
        }
    }

    public DefaultInMemoryAtomSet(CloseableIteratorWithoutException<Atom> it) {
        this();
        while (it.hasNext()) {
            this.atomSet.add(it.next());
        }
    }

    public DefaultInMemoryAtomSet(AtomSet atomset) throws IteratorException {
        this();
        CloseableIterator<Atom> it = atomset.iterator();
        while (it.hasNext()) {
            this.add(new DefaultAtom(it.next()));
        }
    }

    public DefaultInMemoryAtomSet(InMemoryAtomSet atomset) {
        this();
        CloseableIterator it = atomset.iterator();
        while (it.hasNext()) {
            this.add(new DefaultAtom((Atom)it.next()));
        }
    }

    @Override
    public CloseableIteratorWithoutException<Atom> match(Atom atom, Substitution s) {
        AtomType atomType = new AtomType(atom, s);
        return new FilterIteratorWithoutException((CloseableIteratorWithoutException<Atom>)this.atomsByPredicate(atom.getPredicate()), (Filter<Atom>)new TypeFilter(atomType, s.createImageOf(atom)));
    }

    @Override
    public CloseableIteratorWithoutException<Atom> atomsByPredicate(Predicate p) {
        return new CloseableIteratorAdapter<Atom>(this.atomSet.stream().filter(a -> a.getPredicate().equals(p)).iterator());
    }

    @Override
    public CloseableIteratorWithoutException<Term> termsByPredicatePosition(Predicate p, int position) {
        return new CloseableIteratorAdapter<Term>(this.atomSet.stream().filter(a -> a.getPredicate().equals(p)).map(a -> a.getTerm(position)).distinct().iterator());
    }

    @Override
    public CloseableIteratorWithoutException<Predicate> predicatesIterator() {
        return new CloseableIteratorAdapter<Predicate>(this.atomSet.stream().map(a -> a.getPredicate()).distinct().iterator());
    }

    @Override
    public CloseableIteratorWithoutException<Term> termsIterator() {
        return new CloseableIteratorAdapter<Term>(this.atomSet.stream().flatMap(a -> a.getTerms().stream()).distinct().iterator());
    }

    @Override
    @Deprecated
    public CloseableIteratorWithoutException<Term> termsIterator(Term.Type type) {
        return new CloseableIteratorAdapter<Term>(this.getTerms(type).iterator());
    }

    @Override
    public CloseableIteratorWithoutException<Atom> iterator() {
        return new CloseableIteratorAdapter<Atom>(this.atomSet.iterator());
    }

    @Override
    public boolean add(Atom atom) {
        return this.atomSet.add(atom);
    }

    @Override
    public void removeWithoutCheck(Atom atom) {
        this.atomSet.remove(atom);
    }

    @Override
    public boolean remove(Atom atom) {
        return this.atomSet.remove(atom);
    }

    @Override
    public void clear() {
        this.atomSet.clear();
    }

    @Override
    public TermGenerator getFreshSymbolGenerator() {
        return this.freshSymbolGenerator;
    }

    @Override
    public int size() {
        return this.atomSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.atomSet.isEmpty();
    }

    @Override
    public Set<Term> getTerms() {
        return this.atomSet.parallelStream().flatMap(a -> a.getTerms().stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<Predicate> getPredicates() {
        return this.atomSet.parallelStream().map(a -> a.getPredicate()).collect(Collectors.toSet());
    }

    @Override
    public Spliterator<Atom> spliterator() {
        return this.atomSet.spliterator();
    }

    @Override
    public Stream<Atom> stream() {
        return this.atomSet.stream();
    }

    @Override
    public Stream<Atom> parallelStream() {
        return this.atomSet.parallelStream();
    }
}

