/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.atomset.graph;

import fr.lirmm.graphik.integraal.api.core.AbstractTerm;
import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.core.atomset.graph.AtomEdge;
import fr.lirmm.graphik.integraal.core.atomset.graph.CurrentIndexFactory;
import fr.lirmm.graphik.integraal.core.atomset.graph.TermVertex;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import fr.lirmm.graphik.util.stream.CloseableIteratorWithoutException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

abstract class AbstractTermVertex
extends AbstractTerm
implements TermVertex {
    private static final long serialVersionUID = -1087277093687686210L;
    private final Map<Predicate, Collection<Atom>[]> index = CurrentIndexFactory.instance().createMap();
    private Set<Atom> atoms;

    AbstractTermVertex() {
    }

    protected abstract Term getTerm();

    @Override
    public CloseableIteratorWithoutException<Atom> getNeighbors(Predicate p, int position) {
        Collection<Atom> collection;
        Iterator<Object> it = null;
        Collection<Atom>[] map = this.index.get(p);
        if (map != null && (collection = map[position]) != null) {
            it = collection.iterator();
        }
        if (it == null) {
            it = Collections.emptyList().iterator();
        }
        return new CloseableIteratorAdapter<Atom>(it);
    }

    @Override
    public void remove(Predicate p) {
        if (this.index.containsKey(p)) {
            this.index.remove(p);
            this.atoms.removeIf(a -> a.getPredicate().equals(p));
        }
    }

    @Override
    public Set<Atom> getNeighbors() {
        return this.atoms;
    }

    @Override
    public int neighborhoodSize(Predicate p, int position) {
        Collection<Atom> collection;
        int size = 0;
        Collection<Atom>[] map = this.index.get(p);
        if (map != null && (collection = map[position]) != null) {
            size = collection.size();
        }
        return size;
    }

    @Override
    public boolean addNeighbor(AtomEdge a) {
        Collection<Atom>[] map = this.index.get(a.getPredicate());
        if (map == null) {
            map = new Collection[a.getPredicate().getArity()];
            this.index.put(a.getPredicate(), map);
        }
        boolean res = false;
        int i = -1;
        for (Term t : a) {
            ++i;
            if (!this.equals(t)) continue;
            Collection<Atom> collection = map[i];
            if (collection == null) {
                map[i] = collection = new LinkedList<Atom>();
            }
            res = collection.add(a) || res;
        }
        if (res) {
            if (this.atoms == null) {
                this.atoms = new HashSet<Atom>();
            }
            this.atoms.add(a);
        }
        return res;
    }

    @Override
    public boolean removeNeighbor(AtomEdge a) {
        if (!this.containsNeighbor(a)) {
            return false;
        }
        int i = -1;
        for (Term t : a.getTerms()) {
            ++i;
            if (!this.equals(t)) continue;
            Collection<Atom> atomsAtPositionI = this.index.get(a.getPredicate())[i];
            atomsAtPositionI.remove(a);
            if (!atomsAtPositionI.isEmpty()) continue;
            this.index.get((Object)a.getPredicate())[i] = null;
        }
        boolean toDeletePredicate = true;
        for (Collection<Atom> c : this.index.get(a.getPredicate())) {
            if (c == null || c.isEmpty()) continue;
            toDeletePredicate = false;
            break;
        }
        if (toDeletePredicate) {
            this.index.remove(a.getPredicate());
        }
        this.atoms.remove(a);
        return true;
    }

    @Override
    public boolean isEmptyNeighbor() {
        return this.index.isEmpty();
    }

    @Override
    public boolean containsNeighbor(AtomEdge a) {
        return this.atoms.contains(a);
    }

    @Override
    @Deprecated
    public Term.Type getType() {
        return this.getTerm().getType();
    }

    @Override
    public String toString() {
        return this.getTerm().toString();
    }
}

