/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.atomset.graph;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.factory.AtomFactory;
import fr.lirmm.graphik.integraal.core.atomset.graph.AtomEdge;
import fr.lirmm.graphik.integraal.core.atomset.graph.PredicateVertex;
import fr.lirmm.graphik.integraal.core.atomset.graph.TermVertex;
import fr.lirmm.graphik.integraal.core.atomset.graph.TermVertexFactory;
import fr.lirmm.graphik.integraal.core.factory.DefaultAtomFactory;
import java.util.ArrayList;
import java.util.List;

public final class AtomEdgeFactory
implements AtomFactory {
    private static AtomEdgeFactory instance = new AtomEdgeFactory();
    private static final Atom BOTTOM = AtomEdgeFactory.instance().create(DefaultAtomFactory.instance().getBottom());
    private static final Atom TOP = AtomEdgeFactory.instance().create(DefaultAtomFactory.instance().getTop());

    private AtomEdgeFactory() {
    }

    public static AtomEdgeFactory instance() {
        return instance;
    }

    @Override
    public Atom createEquality(Term t1, Term t2) {
        return this.create(Predicate.EQUALITY, t1, t2);
    }

    @Override
    public Atom create(Predicate predicate) {
        return new AtomEdge(new PredicateVertex(predicate));
    }

    @Override
    public Atom create(Predicate predicate, List<Term> terms) {
        ArrayList<TermVertex> termVertices = new ArrayList<TermVertex>();
        for (Term t : terms) {
            termVertices.add(TermVertexFactory.instance().createTerm(t));
        }
        return new AtomEdge(new PredicateVertex(predicate), termVertices);
    }

    @Override
    public Atom create(Predicate predicate, Term ... terms) {
        ArrayList<TermVertex> termVertices = new ArrayList<TermVertex>();
        for (Term t : terms) {
            termVertices.add(TermVertexFactory.instance().createTerm(t));
        }
        return new AtomEdge(new PredicateVertex(predicate), termVertices);
    }

    @Override
    public Atom create(Atom atom) {
        return this.create(atom.getPredicate(), atom.getTerms());
    }

    @Override
    public Atom getTop() {
        return TOP;
    }

    @Override
    public Atom getBottom() {
        return BOTTOM;
    }
}

