/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.atomset.graph;

import fr.lirmm.graphik.integraal.api.core.Constant;
import fr.lirmm.graphik.integraal.api.core.Literal;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.factory.TermFactory;
import fr.lirmm.graphik.integraal.core.atomset.graph.ConstantVertex;
import fr.lirmm.graphik.integraal.core.atomset.graph.LiteralVertex;
import fr.lirmm.graphik.integraal.core.atomset.graph.TermVertex;
import fr.lirmm.graphik.integraal.core.atomset.graph.VariableVertex;
import fr.lirmm.graphik.integraal.core.term.DefaultTermFactory;
import fr.lirmm.graphik.util.URI;

class TermVertexFactory
implements TermFactory {
    private static TermVertexFactory instance = null;

    TermVertexFactory() {
    }

    public static final synchronized TermVertexFactory instance() {
        if (instance == null) {
            instance = new TermVertexFactory();
        }
        return instance;
    }

    @Override
    public TermVertex createTerm(Term term) {
        if (term instanceof VariableVertex) {
            return new VariableVertex(((VariableVertex)term).getTerm());
        }
        if (term instanceof ConstantVertex) {
            return new ConstantVertex(((ConstantVertex)term).getTerm());
        }
        if (term instanceof LiteralVertex) {
            return new LiteralVertex(((LiteralVertex)term).getTerm());
        }
        if (term.isVariable()) {
            return new VariableVertex((Variable)term);
        }
        if (term.isLiteral()) {
            return new LiteralVertex((Literal)term);
        }
        if (term.isConstant()) {
            return new ConstantVertex((Constant)term);
        }
        return null;
    }

    @Override
    @Deprecated
    public Term createTerm(Object o, Term.Type type) {
        switch (type) {
            case VARIABLE: {
                return this.createVariable(o.toString());
            }
            case CONSTANT: {
                return this.createConstant(o.toString());
            }
            case LITERAL: {
                return this.createLiteral(o);
            }
        }
        return null;
    }

    @Override
    public VariableVertex createVariable(Object identifier) {
        return new VariableVertex(DefaultTermFactory.instance().createVariable(identifier));
    }

    @Override
    public LiteralVertex createLiteral(Object value) {
        return new LiteralVertex(DefaultTermFactory.instance().createLiteral(value));
    }

    @Override
    public LiteralVertex createLiteral(URI datatype, Object value) {
        return new LiteralVertex(DefaultTermFactory.instance().createLiteral(datatype, value));
    }

    @Override
    public ConstantVertex createConstant(Object identifier) {
        return new ConstantVertex(DefaultTermFactory.instance().createConstant(identifier));
    }
}

