/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.atomset.splitter;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.atomset.graph.DefaultInMemoryGraphStore;
import fr.lirmm.graphik.integraal.core.atomset.splitter.AtomSetSplitter;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class PiecesSplitter
implements AtomSetSplitter {
    private boolean includeGroundedAtoms;
    private Set<Variable> existentialVariables;

    public PiecesSplitter() {
        this(true);
    }

    public PiecesSplitter(boolean includeGroundedAtoms) {
        this(true, null);
    }

    public PiecesSplitter(boolean includeGroundedAtoms, Set<Variable> existentialVariables) {
        this.includeGroundedAtoms = includeGroundedAtoms;
        this.existentialVariables = existentialVariables;
    }

    @Override
    public Collection<InMemoryAtomSet> split(AtomSet toSplit) throws IteratorException, AtomSetException {
        ArrayList<InMemoryAtomSet> pieces = new ArrayList<InMemoryAtomSet>();
        Set<Variable> variables = this.existentialVariables == null ? toSplit.getVariables() : this.existentialVariables;
        HashSet<Variable> varToTreat = new HashSet<Variable>();
        varToTreat.addAll(variables);
        while (!varToTreat.isEmpty()) {
            Variable root = (Variable)varToTreat.iterator().next();
            ArrayDeque<Variable> queue = new ArrayDeque<Variable>();
            queue.add(root);
            DefaultInMemoryGraphStore piece = new DefaultInMemoryGraphStore();
            while (!queue.isEmpty()) {
                Variable v2 = (Variable)queue.pollFirst();
                varToTreat.remove(v2);
                CloseableIterator<Atom> it = toSplit.atomsByTerm(v2);
                while (it.hasNext()) {
                    Atom a = it.next();
                    a.getVariables().stream().filter(vv -> variables.contains(vv) && varToTreat.contains(vv)).distinct().forEach(vv -> {
                        queue.add((Variable)vv);
                        varToTreat.remove(vv);
                    });
                    piece.add(a);
                }
            }
            pieces.add(piece);
        }
        if (this.includeGroundedAtoms) {
            CloseableIterator<Atom> it = toSplit.iterator();
            while (it.hasNext()) {
                Atom a = it.next();
                long nbVar = a.getVariables().stream().filter(v -> variables.contains(v)).distinct().count();
                if (nbVar != 0L) continue;
                DefaultInMemoryGraphStore atomSet = new DefaultInMemoryGraphStore();
                atomSet.add(a);
                pieces.add(atomSet);
            }
        }
        return pieces;
    }
}

