/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.compilation;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.core.DefaultAtom;
import fr.lirmm.graphik.integraal.core.DefaultVariableGenerator;
import fr.lirmm.graphik.integraal.core.Rules;
import fr.lirmm.graphik.integraal.core.TreeMapSubstitution;
import fr.lirmm.graphik.integraal.core.atomset.DefaultInMemoryAtomSet;
import fr.lirmm.graphik.integraal.core.compilation.AbstractRulesCompilation;
import fr.lirmm.graphik.integraal.core.compilation.IDCondition;
import fr.lirmm.graphik.integraal.core.compilation.IDConditionImpl;
import fr.lirmm.graphik.integraal.core.factory.DefaultRuleFactory;
import fr.lirmm.graphik.integraal.core.factory.DefaultSubstitutionFactory;
import fr.lirmm.graphik.integraal.core.ruleset.LinkedListRuleSet;
import fr.lirmm.graphik.integraal.core.term.DefaultTermFactory;
import fr.lirmm.graphik.util.Partition;
import fr.lirmm.graphik.util.collections.ListComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class IDCompilation
extends AbstractRulesCompilation {
    private static DefaultVariableGenerator varGen = new DefaultVariableGenerator("X" + Integer.toString(IDCompilation.class.hashCode()));
    private Map<Predicate, TreeMap<Predicate, LinkedList<IDCondition>>> conditions = new TreeMap<Predicate, TreeMap<Predicate, LinkedList<IDCondition>>>();

    @Override
    public Iterable<Rule> getSaturation() {
        Predicate p;
        LinkedListRuleSet saturation = new LinkedListRuleSet();
        TreeMap newMap = new TreeMap();
        for (Map.Entry<Predicate, TreeMap<Predicate, LinkedList<IDCondition>>> entry : this.conditions.entrySet()) {
            Predicate q = entry.getKey();
            for (Map.Entry<Predicate, LinkedList<IDCondition>> map : entry.getValue().entrySet()) {
                p = map.getKey();
                TreeMap head = (TreeMap)newMap.get(p);
                if (head == null) {
                    head = new TreeMap(new ListComparator());
                    newMap.put(p, head);
                }
                for (IDCondition conditionPQ : map.getValue()) {
                    InMemoryAtomSet atomSet = (InMemoryAtomSet)head.get(conditionPQ.getBody());
                    if (atomSet == null) {
                        atomSet = new DefaultInMemoryAtomSet();
                        head.put(conditionPQ.getBody(), atomSet);
                    }
                    atomSet.addAll(conditionPQ.generateRule(p, q).getHead());
                }
            }
        }
        for (Map.Entry<Predicate, TreeMap<Predicate, LinkedList<IDCondition>>> entry : newMap.entrySet()) {
            p = entry.getKey();
            for (Map.Entry<Predicate, LinkedList<IDCondition>> e2 : entry.getValue().entrySet()) {
                LinkedList<Term> terms = new LinkedList<Term>();
                for (Integer i : (List)((Object)e2.getKey())) {
                    terms.add(DefaultTermFactory.instance().createVariable("X" + i));
                }
                DefaultInMemoryAtomSet body = new DefaultInMemoryAtomSet();
                body.add(new DefaultAtom(p, terms));
                saturation.add(DefaultRuleFactory.instance().create(body, (InMemoryAtomSet)((Object)e2.getValue())));
            }
        }
        return saturation;
    }

    @Override
    public void compile(Iterator<Rule> ruleset) {
        LinkedList<Rule> compilable = this.extractCompilable(ruleset);
        if (this.getProfiler() != null) {
            this.getProfiler().start("Compilation total time");
        }
        this.createIDCondition(compilable.iterator());
        this.computeSaturation();
        if (this.getProfiler() != null) {
            this.getProfiler().stop("Compilation total time");
        }
    }

    @Override
    public void load(Iterator<Rule> ruleSet, Iterator<Rule> saturation) {
        if (this.getProfiler() != null) {
            this.getProfiler().start("Compilation load time");
        }
        this.extractCompilable(ruleSet);
        Rules.SinglePieceRulesIterator monoPiecesaturation = Rules.computeSinglePiece(saturation);
        this.createIDCondition(monoPiecesaturation);
        if (this.getProfiler() != null) {
            this.getProfiler().stop("Compilation load time");
        }
    }

    public List<IDCondition> getConditions(Predicate predB, Predicate predH) {
        Map condH;
        LinkedList res = null;
        if (predB.equals(predH)) {
            res = new LinkedList();
            ArrayList<Term> terms = new ArrayList<Term>(predB.getArity());
            for (int i = 0; i < predH.getArity(); ++i) {
                terms.add(varGen.getFreshSymbol());
            }
            res.add(new IDConditionImpl(terms, terms, varGen));
        }
        if ((condH = (Map)this.conditions.get(predH)) != null) {
            res = (LinkedList)condH.get(predB);
        }
        if (res != null) {
            return res;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isCompilable(Rule r) {
        return Rules.hasAtomicBody(r) && Rules.hasAtomicHead(r) && r.getExistentials().isEmpty() && r.getConstants().isEmpty();
    }

    @Override
    public boolean isMappable(Predicate father, Predicate son) {
        if (son.equals(father)) {
            return true;
        }
        return !this.getConditions(son, father).isEmpty();
    }

    public LinkedList<Substitution> homomorphism(Atom father, Atom son, Substitution s) {
        LinkedList<Substitution> res = new LinkedList<Substitution>();
        Predicate predB = son.getPredicate();
        Predicate predH = father.getPredicate();
        List<IDCondition> conds = this.getConditions(predB, predH);
        for (IDCondition cond : conds) {
            Substitution homo;
            if (!cond.checkBody(son.getTerms()) || (homo = cond.homomorphism(father.getTerms(), son.getTerms(), s)) == null) continue;
            res.add(new TreeMapSubstitution(homo));
        }
        return res;
    }

    public LinkedList<Partition<Term>> getUnification(Atom father, Atom son) {
        LinkedList<Partition<Term>> res = new LinkedList<Partition<Term>>();
        Predicate predB = son.getPredicate();
        Predicate predH = father.getPredicate();
        List<IDCondition> conds = this.getConditions(predB, predH);
        for (IDCondition cond : conds) {
            Partition<Term> unif = cond.generateUnification(son.getTerms(), father.getTerms());
            if (unif == null) continue;
            res.add(unif);
        }
        return res;
    }

    @Override
    public boolean isImplied(Atom father, Atom son) {
        Predicate predB = son.getPredicate();
        Predicate predH = father.getPredicate();
        List<IDCondition> conds = this.getConditions(predB, predH);
        for (IDCondition cond : conds) {
            if (!cond.imply(son.getTerms(), father.getTerms())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Predicate> getUnifiablePredicate(Predicate p) {
        LinkedList<Predicate> res = new LinkedList<Predicate>();
        Map condH = this.conditions.get(p);
        res.add(p);
        if (condH != null) {
            res.addAll(condH.keySet());
        }
        return res;
    }

    @Override
    public Collection<Pair<Atom, Substitution>> getRewritingOf(Atom atom) {
        TreeSet<Pair<Atom, Substitution>> res = new TreeSet<Pair<Atom, Substitution>>();
        res.add((Pair<Atom, Substitution>)new ImmutablePair((Object)atom, (Object)DefaultSubstitutionFactory.instance().createSubstitution()));
        Predicate predH = atom.getPredicate();
        Map condH = this.conditions.get(predH);
        if (condH != null) {
            for (Map.Entry entry : condH.entrySet()) {
                Predicate predB = (Predicate)entry.getKey();
                LinkedList conds = (LinkedList)entry.getValue();
                for (IDCondition cond : conds) {
                    Pair<List<Term>, Substitution> ret = cond.generateBody(atom.getTerms());
                    if (ret == null) continue;
                    List generatedBody = (List)ret.getLeft();
                    res.add((Pair<Atom, Substitution>)new ImmutablePair((Object)new DefaultAtom(predB, generatedBody), (Object)((Substitution)ret.getRight())));
                }
            }
        }
        return res;
    }

    @Override
    public boolean isEmpty() {
        return this.conditions.isEmpty();
    }

    private void createIDCondition(Iterator<Rule> compilable) {
        if (this.getProfiler() != null) {
            this.getProfiler().start("Compilation create IDCondition time");
        }
        while (compilable.hasNext()) {
            Rule ru = compilable.next();
            Atom b = (Atom)ru.getBody().iterator().next();
            Atom h = (Atom)ru.getHead().iterator().next();
            IDConditionImpl cond = new IDConditionImpl(b.getTerms(), h.getTerms(), varGen);
            IDCompilation.addCondition(b.getPredicate(), h.getPredicate(), cond, this.conditions);
        }
        if (this.getProfiler() != null) {
            this.getProfiler().stop("Compilation create IDCondition time");
        }
    }

    private static TreeMap<Predicate, TreeMap<Predicate, LinkedList<IDCondition>>> deepCopyMapMapList(Map<Predicate, TreeMap<Predicate, LinkedList<IDCondition>>> map) {
        TreeMap<Predicate, TreeMap<Predicate, LinkedList<IDCondition>>> tmp = new TreeMap<Predicate, TreeMap<Predicate, LinkedList<IDCondition>>>();
        for (Map.Entry<Predicate, TreeMap<Predicate, LinkedList<IDCondition>>> e : map.entrySet()) {
            tmp.put(e.getKey(), IDCompilation.deepCopyMapList((Map<Predicate, LinkedList<IDCondition>>)e.getValue()));
        }
        return tmp;
    }

    private static TreeMap<Predicate, LinkedList<IDCondition>> deepCopyMapList(Map<Predicate, LinkedList<IDCondition>> map) {
        TreeMap<Predicate, LinkedList<IDCondition>> tmp = new TreeMap<Predicate, LinkedList<IDCondition>>();
        for (Map.Entry<Predicate, LinkedList<IDCondition>> e : map.entrySet()) {
            tmp.put(e.getKey(), new LinkedList(e.getValue()));
        }
        return tmp;
    }

    private void computeSaturation() {
        TreeMap<Predicate, TreeMap<Predicate, LinkedList<IDCondition>>> conditionsTmp = IDCompilation.deepCopyMapMapList(this.conditions);
        for (Map.Entry e : conditionsTmp.entrySet()) {
            Predicate q = (Predicate)e.getKey();
            for (Map.Entry map : ((TreeMap)e.getValue()).entrySet()) {
                Predicate p = (Predicate)map.getKey();
                for (IDCondition conditionPQ : (LinkedList)map.getValue()) {
                    this.computeSaturation(conditionsTmp, p, q, conditionPQ);
                }
            }
        }
    }

    private void computeSaturation(Map<Predicate, TreeMap<Predicate, LinkedList<IDCondition>>> conditionsTmp, Predicate p, Predicate q, IDCondition conditionPQ) {
        TreeMap<Predicate, LinkedList<IDCondition>> map = conditionsTmp.get(p);
        if (map != null) {
            for (Map.Entry<Predicate, LinkedList<IDCondition>> e : map.entrySet()) {
                Predicate r = e.getKey();
                for (IDCondition conditionRP : e.getValue()) {
                    IDCondition conditionRQ = conditionRP.composeWith(conditionPQ);
                    if (conditionRQ == null || r.equals(q) && conditionRQ.isIdentity() || !IDCompilation.addCondition(r, q, conditionRQ, this.conditions)) continue;
                    this.computeSaturation(conditionsTmp, r, q, conditionRQ);
                }
            }
        }
    }

    private static boolean addCondition(Predicate predBody, Predicate predHead, IDCondition cond, Map<Predicate, TreeMap<Predicate, LinkedList<IDCondition>>> conditionMatrix) {
        LinkedList<IDCondition> conds;
        TreeMap<Predicate, LinkedList<IDCondition>> condH = conditionMatrix.get(predHead);
        if (condH == null) {
            condH = new TreeMap();
            conditionMatrix.put(predHead, condH);
        }
        if ((conds = condH.get(predBody)) == null) {
            conds = new LinkedList();
            condH.put(predBody, conds);
        }
        if (!conds.contains(cond)) {
            conds.add(cond);
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }

    public void appendTo(StringBuilder sb) {
        for (Rule r : this.getSaturation()) {
            r.appendTo(sb);
            sb.append('\n');
        }
    }
}

