/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.compilation;

import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.core.VariableGenerator;
import fr.lirmm.graphik.integraal.core.DefaultAtom;
import fr.lirmm.graphik.integraal.core.DefaultFreshVarMapper;
import fr.lirmm.graphik.integraal.core.DefaultVariableGenerator;
import fr.lirmm.graphik.integraal.core.Substitutions;
import fr.lirmm.graphik.integraal.core.compilation.IDCompilation;
import fr.lirmm.graphik.integraal.core.compilation.IDCondition;
import fr.lirmm.graphik.integraal.core.factory.DefaultRuleFactory;
import fr.lirmm.graphik.integraal.core.factory.DefaultSubstitutionFactory;
import fr.lirmm.graphik.integraal.core.term.DefaultTermFactory;
import fr.lirmm.graphik.util.MethodNotImplementedError;
import fr.lirmm.graphik.util.Partition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

class IDConditionImpl
implements IDCondition {
    private VariableGenerator varGen;
    private int[] condBody;
    private int[] condHead;

    public IDConditionImpl(int[] condBody, int[] condHead) {
        this(condBody, condHead, (VariableGenerator)new DefaultVariableGenerator("X" + Integer.toString(IDCompilation.class.hashCode())));
    }

    public IDConditionImpl(List<Term> body, List<Term> head) {
        this(body, head, new DefaultVariableGenerator("X" + Integer.toString(IDCompilation.class.hashCode())));
    }

    public IDConditionImpl(List<Term> body, List<Term> head, DefaultVariableGenerator varGen) {
        this.varGen = varGen;
        this.condBody = new int[body.size()];
        int var = -1;
        for (int i = 0; i < body.size(); ++i) {
            this.condBody[i] = -1;
            for (int j = 0; j < i; ++j) {
                if (!body.get(i).equals(body.get(j))) continue;
                this.condBody[i] = this.condBody[j];
            }
            if (this.condBody[i] != -1) continue;
            this.condBody[i] = ++var;
        }
        this.condHead = new int[head.size()];
        for (int j = 0; j < head.size(); ++j) {
            boolean found = false;
            for (int i = 0; !found && i < body.size(); ++i) {
                if (!body.get(i).equals(head.get(j))) continue;
                found = true;
                this.condHead[j] = this.condBody[i];
            }
        }
    }

    public IDConditionImpl(int[] condBody, int[] condHead, VariableGenerator varGen) {
        this.condBody = condBody;
        this.condHead = condHead;
        this.varGen = varGen;
    }

    @Override
    public List<Integer> getBody() {
        ArrayList<Integer> list = new ArrayList<Integer>(this.condBody.length);
        for (int i = 0; i < this.condBody.length; ++i) {
            list.add(this.condBody[i]);
        }
        return list;
    }

    @Override
    public boolean imply(List<Term> body, List<Term> head) {
        int i;
        if (body.size() != this.condBody.length) {
            return false;
        }
        Term[] check = new Term[body.size()];
        for (i = 0; i < this.condBody.length; ++i) {
            if (check[this.condBody[i]] == null) {
                check[this.condBody[i]] = body.get(i);
                continue;
            }
            if (Objects.equals(body.get(i), check[this.condBody[i]])) continue;
            return false;
        }
        if (head.size() != this.condHead.length) {
            return false;
        }
        for (i = 0; i < head.size(); ++i) {
            if (head.get(i).equals(check[this.condHead[i]])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isIdentity() {
        return Arrays.equals(this.condBody, this.condHead);
    }

    @Override
    public boolean checkBody(List<Term> body) {
        if (body.size() != this.condBody.length) {
            return false;
        }
        Term[] check = new Term[body.size()];
        for (int i = 0; i < this.condBody.length; ++i) {
            if (check[this.condBody[i]] == null) {
                check[this.condBody[i]] = body.get(i);
                continue;
            }
            if (check[this.condBody[i]].equals(body.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Pair<List<Term>, Substitution> generateBody(List<Term> head) {
        Substitution s = DefaultSubstitutionFactory.instance().createSubstitution();
        TreeSet<Variable> toRemoveFromPartition = new TreeSet<Variable>();
        DefaultFreshVarMapper<Integer> freshVar = new DefaultFreshVarMapper<Integer>(this.varGen);
        for (int i = 0; i < this.condHead.length; ++i) {
            Variable v = freshVar.getImageOf(this.condHead[i]);
            toRemoveFromPartition.add(v);
            if (s.aggregate(v, head.get(i))) continue;
            return null;
        }
        ArrayList<Term> body = new ArrayList<Term>(this.condBody.length);
        for (int i = 0; i < this.condBody.length; ++i) {
            Variable v = freshVar.getImageOf(this.condBody[i]);
            toRemoveFromPartition.add(v);
            body.add(s.createImageOf(v));
        }
        for (Variable v : toRemoveFromPartition) {
            s.remove(v);
        }
        return new ImmutablePair(body, (Object)s);
    }

    @Override
    public List<Term> generateHead() {
        DefaultFreshVarMapper<Integer> freshVar = new DefaultFreshVarMapper<Integer>(this.varGen);
        LinkedList<Term> head = new LinkedList<Term>();
        for (int i = 0; i < this.condHead.length; ++i) {
            head.add(freshVar.getImageOf(this.condHead[i]));
        }
        return head;
    }

    @Override
    public Partition<Term> generateUnification(List<Term> body, List<Term> head) {
        Term t;
        int i;
        Partition<Term> res = new Partition<Term>();
        Term[] map = new Term[body.size()];
        for (i = 0; i < this.condBody.length; ++i) {
            t = body.get(i);
            if (map[this.condBody[i]] == null) {
                map[this.condBody[i]] = t;
                continue;
            }
            res.add(map[this.condBody[i]], t);
        }
        for (i = 0; i < this.condHead.length; ++i) {
            t = head.get(i);
            res.add(map[this.condHead[i]], t);
        }
        for (ArrayList classs : res) {
            Term cst = null;
            for (Term t2 : classs) {
                if (!t2.isConstant()) continue;
                if (cst == null) {
                    cst = t2;
                    continue;
                }
                if (cst.equals(t2)) continue;
                return null;
            }
        }
        return res;
    }

    @Override
    public Substitution homomorphism(List<Term> head, List<Term> to) {
        return this.homomorphism(head, to, Substitutions.emptySubstitution());
    }

    @Override
    public Substitution homomorphism(List<Term> head, List<Term> to, Substitution initialSub) {
        if (!this.checkBody(to)) {
            return null;
        }
        Set<Variable> fixedTerms = initialSub.getTerms();
        Pair<List<Term>, Substitution> ret = this.generateBody(head);
        if (ret == null) {
            return null;
        }
        Substitution s = (Substitution)ret.getRight();
        Substitution homo = DefaultSubstitutionFactory.instance().createSubstitution();
        List generatedBody = (List)ret.getLeft();
        Iterator itFrom = generatedBody.iterator();
        Iterator<Term> itTo = to.iterator();
        while (itFrom.hasNext() && itTo.hasNext()) {
            Term termFrom = (Term)itFrom.next();
            Term termTo = itTo.next();
            if (!(termFrom.isConstant() || fixedTerms.contains(termFrom) ? !initialSub.createImageOf(termFrom).equals(termTo) : !homo.put((Variable)termFrom, termTo))) continue;
            return null;
        }
        if (itFrom.hasNext() || itTo.hasNext()) {
            throw new Error("Wrong term number");
        }
        for (Variable t : s.getTerms()) {
            homo.put(t, homo.createImageOf(s.createImageOf(t)));
        }
        return homo;
    }

    @Override
    public IDCondition composeWith(IDCondition condition2) {
        if (condition2 instanceof IDConditionImpl) {
            return this.composeWith((IDConditionImpl)condition2);
        }
        throw new MethodNotImplementedError();
    }

    public IDCondition composeWith(IDConditionImpl condition) {
        int i;
        int i2;
        int[] newCondBody = new int[this.condBody.length];
        int[] newCondHead = new int[condition.condHead.length];
        Partition<Integer> partition = new Partition<Integer>();
        for (i2 = 0; i2 < this.condHead.length; ++i2) {
            partition.add(this.condHead[i2] * 2, condition.condBody[i2] * 2 + 1);
        }
        for (i2 = 0; i2 < newCondBody.length; ++i2) {
            newCondBody[i2] = partition.getRepresentant(this.condBody[i2] * 2);
        }
        for (i2 = 0; i2 < newCondHead.length; ++i2) {
            newCondHead[i2] = partition.getRepresentant(condition.condHead[i2] * 2 + 1);
        }
        int var = -1;
        int[] map = new int[newCondBody.length * 2 + 1];
        for (i = 0; i < map.length; ++i) {
            map[i] = -1;
        }
        for (i = 0; i < newCondBody.length; ++i) {
            if (map[newCondBody[i]] == -1) {
                map[newCondBody[i]] = ++var;
            }
            newCondBody[i] = map[newCondBody[i]];
        }
        for (i = 0; i < newCondHead.length; ++i) {
            newCondHead[i] = map[newCondHead[i]];
        }
        return new IDConditionImpl(newCondBody, newCondHead, this.varGen);
    }

    public String toString() {
        boolean isFirst = true;
        Object s = "([";
        for (int i = 0; i < this.condBody.length; ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                s = (String)s + " ";
            }
            s = (String)s + this.condBody[i];
        }
        s = (String)s + "] -> [";
        isFirst = true;
        int[] nArray = this.condHead;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            if (isFirst) {
                isFirst = false;
            } else {
                s = (String)s + " ";
            }
            s = (String)s + i2;
        }
        s = (String)s + "])";
        return s;
    }

    @Override
    public Rule generateRule(Predicate bodyPredicate, Predicate headPredicate) {
        int i;
        ArrayList<Term> body = new ArrayList<Term>();
        LinkedList<Term> head = new LinkedList<Term>();
        for (i = 0; i < this.condBody.length; ++i) {
            body.add(DefaultTermFactory.instance().createVariable("X" + this.condBody[i]));
        }
        for (i = 0; i < this.condHead.length; ++i) {
            head.add(DefaultTermFactory.instance().createVariable("X" + this.condHead[i]));
        }
        Rule r = DefaultRuleFactory.instance().create();
        r.getBody().add(new DefaultAtom(bodyPredicate, body));
        r.getHead().add(new DefaultAtom(headPredicate, head));
        return r;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof IDConditionImpl)) {
            return false;
        }
        IDConditionImpl other = (IDConditionImpl)obj;
        return Arrays.equals(this.condBody, other.condBody) && Arrays.equals(this.condHead, other.condHead);
    }
}

