/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.factory;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.factory.StoreFactory;
import fr.lirmm.graphik.integraal.api.store.Store;
import fr.lirmm.graphik.integraal.core.atomset.graph.DefaultInMemoryGraphStore;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorWithoutException;
import fr.lirmm.graphik.util.stream.IteratorException;

public final class DefaultStoreFactory
implements StoreFactory {
    private static DefaultStoreFactory instance = new DefaultStoreFactory();

    private DefaultStoreFactory() {
    }

    public static DefaultStoreFactory instance() {
        return instance;
    }

    @Override
    public DefaultInMemoryGraphStore create() {
        return new DefaultInMemoryGraphStore();
    }

    @Override
    public Store create(Atom[] atoms) {
        DefaultInMemoryGraphStore atomset = this.create();
        for (Atom a : atoms) {
            atomset.add(a);
        }
        return atomset;
    }

    @Override
    public Store create(CloseableIterator<Atom> atoms) throws IteratorException {
        DefaultInMemoryGraphStore atomset = this.create();
        while (atoms.hasNext()) {
            atomset.add(atoms.next());
        }
        return atomset;
    }

    @Override
    public Store create(CloseableIteratorWithoutException<Atom> atoms) {
        DefaultInMemoryGraphStore atomset = this.create();
        while (atoms.hasNext()) {
            atomset.add(atoms.next());
        }
        return atomset;
    }

    @Override
    public Store create(AtomSet src) throws IteratorException {
        DefaultInMemoryGraphStore atomset = this.create();
        CloseableIterator<Atom> it = src.iterator();
        while (it.hasNext()) {
            Atom a = it.next();
            atomset.add(a);
        }
        return atomset;
    }

    @Override
    public Store create(InMemoryAtomSet src) {
        try {
            return this.create((AtomSet)src);
        }
        catch (IteratorException e) {
            throw new Error("Should never happen");
        }
    }

    @Override
    public Store create(Atom atom) {
        DefaultInMemoryGraphStore atomset = this.create();
        atomset.add(atom);
        return atomset;
    }
}

