/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.grd;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.GraphOfRuleDependencies;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.RuleSet;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.unifier.DependencyChecker;
import fr.lirmm.graphik.integraal.core.LabelRuleComparator;
import fr.lirmm.graphik.integraal.core.Substitutions;
import fr.lirmm.graphik.integraal.core.compilation.NoCompilation;
import fr.lirmm.graphik.integraal.core.factory.DefaultConjunctiveQueryFactory;
import fr.lirmm.graphik.integraal.core.ruleset.IndexedByBodyPredicatesRuleSet;
import fr.lirmm.graphik.integraal.core.ruleset.LinkedListRuleSet;
import fr.lirmm.graphik.integraal.core.unifier.DefaultUnifierAlgorithm;
import fr.lirmm.graphik.integraal.core.unifier.QueryUnifier;
import fr.lirmm.graphik.integraal.core.unifier.RuleDependencyUtils;
import fr.lirmm.graphik.integraal.core.unifier.UnifierUtils;
import fr.lirmm.graphik.util.graph.scc.StronglyConnectedComponentsGraph;
import fr.lirmm.graphik.util.stream.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jgrapht.Graph;
import org.jgrapht.alg.cycle.CycleDetector;
import org.jgrapht.graph.DefaultDirectedGraph;

public class DefaultGraphOfRuleDependencies
implements GraphOfRuleDependencies {
    private ArrayList<Set<Substitution>> edgesValue;
    private boolean computingUnifiers;
    private Graph<Rule, Integer> grd;
    private RulesCompilation compilation;
    private DependencyChecker[] checkers;
    private static final String PREFIX = "R" + new Date().hashCode() + "-";
    private static int ruleIndex = 0;

    public DefaultGraphOfRuleDependencies(RuleSet rules, RulesCompilation compilation, boolean withUnifiers, DependencyChecker[] checkers) {
        this.compilation = compilation;
        this.checkers = checkers;
        this.computingUnifiers = withUnifiers;
        this.grd = new DefaultDirectedGraph(Integer.class);
        this.edgesValue = new ArrayList();
        for (Rule rule : rules) {
            this.addRuleToGRD(rule);
        }
        if (compilation == null || compilation == NoCompilation.instance()) {
            this.computeDependencies(checkers);
        } else {
            this.computeDependencies(compilation, checkers);
        }
    }

    public DefaultGraphOfRuleDependencies(RuleSet rules, RulesCompilation compilation, boolean withUnifiers) {
        this(rules, compilation, withUnifiers, new DependencyChecker[0]);
    }

    public DefaultGraphOfRuleDependencies(Iterator<Rule> rules, RulesCompilation compilation, boolean withUnifiers) {
        this((RuleSet)new LinkedListRuleSet(rules), compilation, withUnifiers);
    }

    public DefaultGraphOfRuleDependencies(Iterable<Rule> rules, RulesCompilation compilation, boolean withUnifiers) {
        this((RuleSet)new LinkedListRuleSet(rules), compilation, withUnifiers);
    }

    public DefaultGraphOfRuleDependencies(RuleSet rules, RulesCompilation compilation) {
        this(rules, compilation, false);
    }

    public DefaultGraphOfRuleDependencies(Iterator<Rule> rules, RulesCompilation compilation) {
        this((RuleSet)new LinkedListRuleSet(rules), compilation);
    }

    public DefaultGraphOfRuleDependencies(Iterable<Rule> rules, RulesCompilation compilation) {
        this((RuleSet)new LinkedListRuleSet(rules), compilation);
    }

    public DefaultGraphOfRuleDependencies(RuleSet rules, boolean withUnifiers, DependencyChecker ... checkers) {
        this(rules, NoCompilation.instance(), withUnifiers, checkers);
    }

    public DefaultGraphOfRuleDependencies(Iterator<Rule> rules, boolean withUnifiers, DependencyChecker ... checkers) {
        this((RuleSet)new LinkedListRuleSet(rules), withUnifiers, checkers);
    }

    public DefaultGraphOfRuleDependencies(Iterable<Rule> rules, boolean withUnifiers, DependencyChecker ... checkers) {
        this((RuleSet)new LinkedListRuleSet(rules), withUnifiers, checkers);
    }

    public DefaultGraphOfRuleDependencies(RuleSet rules, DependencyChecker ... checkers) {
        this(rules, NoCompilation.instance(), false, checkers);
    }

    public DefaultGraphOfRuleDependencies(Iterator<Rule> rules, DependencyChecker ... checkers) {
        this((RuleSet)new LinkedListRuleSet(rules), checkers);
    }

    public DefaultGraphOfRuleDependencies(Iterable<Rule> rules, DependencyChecker ... checkers) {
        this((RuleSet)new LinkedListRuleSet(rules), checkers);
    }

    @Override
    public boolean hasCircuit() {
        return new CycleDetector(this.grd).detectCycles();
    }

    public Set<Substitution> getUnifiers(Integer e) {
        if (this.computingUnifiers) {
            return Collections.unmodifiableSet(this.edgesValue.get(e));
        }
        if (this.checkers.length > 0) {
            return this.computeDependency((Rule)this.grd.getEdgeSource((Object)e), (Rule)this.grd.getEdgeTarget((Object)e), this.checkers);
        }
        return this.computeDependency((Rule)this.grd.getEdgeSource((Object)e), (Rule)this.grd.getEdgeTarget((Object)e), this.compilation, this.checkers);
    }

    @Override
    public DefaultGraphOfRuleDependencies getSubGraph(Iterable<Rule> rules) {
        return new DefaultGraphOfRuleDependencies((RuleSet)new LinkedListRuleSet(rules), this.compilation, this.computingUnifiers, this.checkers);
    }

    @Override
    public Iterable<Rule> getRules() {
        return this.grd.vertexSet();
    }

    @Override
    public Set<Rule> getTriggeredRules(Rule src) {
        HashSet<Rule> set = new HashSet<Rule>();
        for (Integer i : this.grd.outgoingEdgesOf((Object)src)) {
            set.add((Rule)this.grd.getEdgeTarget((Object)i));
        }
        return set;
    }

    @Override
    public Set<Pair<Rule, Substitution>> getTriggeredRulesWithUnifiers(Rule src) {
        HashSet<Pair<Rule, Substitution>> set = new HashSet<Pair<Rule, Substitution>>();
        for (Integer i : this.grd.outgoingEdgesOf((Object)src)) {
            Rule target = (Rule)this.grd.getEdgeTarget((Object)i);
            for (Substitution u : this.getUnifiers(i)) {
                ImmutablePair p = new ImmutablePair((Object)target, (Object)u);
                set.add((Pair<Rule, Substitution>)p);
            }
        }
        return set;
    }

    @Override
    public boolean existUnifier(Rule src, Rule dest) {
        return this.grd.getEdge((Object)src, (Object)dest) != null;
    }

    @Override
    public Set<Substitution> getUnifiers(Rule src, Rule dest) {
        Integer index = (Integer)this.grd.getEdge((Object)src, (Object)dest);
        if (index != null) {
            return this.getUnifiers(index);
        }
        return Collections.emptySet();
    }

    @Override
    public StronglyConnectedComponentsGraph<Rule> getStronglyConnectedComponentsGraph() {
        return new StronglyConnectedComponentsGraph<Rule>(this.grd);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        TreeSet<Rule> rules = new TreeSet<Rule>(new LabelRuleComparator());
        for (Rule r : this.grd.vertexSet()) {
            rules.add(r);
        }
        for (Rule src : rules) {
            for (Integer e : this.grd.outgoingEdgesOf((Object)src)) {
                Rule dest = (Rule)this.grd.getEdgeTarget((Object)e);
                s.append(src.getLabel());
                s.append(" -");
                if (this.computingUnifiers) {
                    for (Substitution sub : this.edgesValue.get((Integer)this.grd.getEdge((Object)src, (Object)dest))) {
                        s.append(sub);
                    }
                }
                s.append("-> ");
                s.append(dest.getLabel());
                s.append('\n');
            }
        }
        return s.toString();
    }

    protected void addDependency(Rule src, Set<Substitution> subs, Rule dest) {
        Integer edgeIndex = (Integer)this.grd.getEdge((Object)src, (Object)dest);
        if (edgeIndex == null) {
            edgeIndex = this.edgesValue.size();
            this.edgesValue.add(edgeIndex, subs);
            this.grd.addEdge((Object)src, (Object)dest, (Object)edgeIndex);
        } else {
            this.edgesValue.get(edgeIndex).addAll(subs);
        }
    }

    protected void addDependency(Rule src, Substitution sub, Rule dest) {
        HashSet<Substitution> set = new HashSet<Substitution>();
        set.add(sub);
        this.addDependency(src, set, dest);
    }

    protected void addRuleToGRD(Rule r) {
        if (r.getLabel().isEmpty()) {
            r.setLabel(PREFIX + ruleIndex++);
        }
        this.grd.addVertex((Object)r);
    }

    protected void addRulesToGRD(Iterable<Rule> rules) {
        for (Rule r : rules) {
            this.addRuleToGRD(r);
        }
    }

    protected void computeDependencies(RulesCompilation compilation, DependencyChecker[] checkers) {
        Set rules = this.grd.vertexSet();
        for (Rule r1 : rules) {
            for (Rule r2 : rules) {
                Set<Substitution> unifiers = this.computeDependency(r1, r2, compilation, checkers);
                if (unifiers.isEmpty()) continue;
                this.addDependency(r1, unifiers, r2);
            }
        }
    }

    protected Set<Substitution> computeDependency(Rule ra, Rule rb, RulesCompilation compilation, DependencyChecker[] checkers) {
        boolean EXISTS = checkers.length == 0;
        List<QueryUnifier> unifiers = UnifierUtils.getSinglePieceUnifiersNAHR(DefaultConjunctiveQueryFactory.instance().create(rb.getBody()), ra, compilation, EXISTS);
        HashSet<Substitution> ret = new HashSet<Substitution>();
        if (unifiers.isEmpty()) {
            return ret;
        }
        if (EXISTS) {
            ret.add(unifiers.get(0).getAssociatedSubstitution());
        } else {
            for (QueryUnifier qunifier : unifiers) {
                Substitution substitution = qunifier.getAssociatedSubstitution();
                if (!RuleDependencyUtils.validateUnifier(ra, rb, substitution, checkers)) continue;
                ret.add(substitution);
                break;
            }
        }
        return ret;
    }

    protected Set<Substitution> computeDependency(Rule r1, Rule r2, DependencyChecker[] checkers) {
        Substitution s1 = DefaultUnifierAlgorithm.getSourceVariablesSubstitution();
        Rule source = s1.createImageOf(r1);
        Substitution s2 = DefaultUnifierAlgorithm.getTargetVariablesSubstitution();
        Rule target = s2.createImageOf(r2);
        Set<Substitution> ret = null;
        if (this.computingUnifiers) {
            ret = Iterators.toSet(DefaultUnifierAlgorithm.instance().computePieceUnifier(source, target, checkers));
        } else if (DefaultUnifierAlgorithm.instance().existPieceUnifier(source, target, checkers)) {
            ret = Collections.singleton(Substitutions.emptySubstitution());
        }
        if (ret == null) {
            return new HashSet<Substitution>();
        }
        return ret;
    }

    protected void computeDependencies(DependencyChecker ... checkers) {
        IndexedByBodyPredicatesRuleSet index = new IndexedByBodyPredicatesRuleSet(this.grd.vertexSet());
        TreeSet<String> marked = new TreeSet<String>();
        for (Rule r1 : this.grd.vertexSet()) {
            marked.clear();
            for (Atom a : r1.getHead()) {
                Iterable<Rule> candidates = index.getRulesByBodyPredicate(a.getPredicate());
                if (candidates == null) continue;
                for (Rule r2 : candidates) {
                    Set<Substitution> unifiers;
                    if (!marked.add(r2.getLabel()) || (unifiers = this.computeDependency(r1, r2, checkers)).isEmpty()) continue;
                    this.addDependency(r1, unifiers, r2);
                }
            }
        }
    }
}

