/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.mapper;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.mapper.Mapper;
import fr.lirmm.graphik.integraal.core.atomset.DefaultInMemoryAtomSet;
import fr.lirmm.graphik.integraal.core.factory.DefaultAtomFactory;
import fr.lirmm.graphik.integraal.core.factory.DefaultConjunctiveQueryFactory;
import fr.lirmm.graphik.integraal.core.factory.DefaultRuleFactory;
import fr.lirmm.graphik.integraal.core.mapper.InverseMapper;
import fr.lirmm.graphik.util.stream.CloseableIterator;

public abstract class AbstractMapper
implements Mapper {
    private Mapper inverse = new InverseMapper(this);

    protected AbstractMapper() {
    }

    @Override
    public Atom map(Atom atom) {
        return DefaultAtomFactory.instance().create(this.map(atom.getPredicate()), atom.getTerms());
    }

    @Override
    public Atom unmap(Atom atom) {
        return DefaultAtomFactory.instance().create(this.unmap(atom.getPredicate()), atom.getTerms());
    }

    @Override
    public ConjunctiveQuery map(ConjunctiveQuery cq) {
        return DefaultConjunctiveQueryFactory.instance().create(cq.getLabel(), this.map(cq.getAtomSet()), cq.getAnswerVariables());
    }

    @Override
    public ConjunctiveQuery unmap(ConjunctiveQuery cq) {
        return DefaultConjunctiveQueryFactory.instance().create(cq.getLabel(), this.unmap(cq.getAtomSet()), cq.getAnswerVariables());
    }

    @Override
    public Rule map(Rule rule) {
        InMemoryAtomSet body = this.map(rule.getBody());
        InMemoryAtomSet head = this.map(rule.getHead());
        return DefaultRuleFactory.instance().create(rule.getLabel(), body, head);
    }

    @Override
    public Rule unmap(Rule rule) {
        InMemoryAtomSet body = this.unmap(rule.getBody());
        InMemoryAtomSet head = this.unmap(rule.getHead());
        return DefaultRuleFactory.instance().create(rule.getLabel(), body, head);
    }

    @Override
    public InMemoryAtomSet map(InMemoryAtomSet atomset) {
        InMemoryAtomSet mapped;
        try {
            mapped = (InMemoryAtomSet)atomset.getClass().newInstance();
        }
        catch (InstantiationException e) {
            mapped = new DefaultInMemoryAtomSet();
        }
        catch (IllegalAccessException e) {
            mapped = new DefaultInMemoryAtomSet();
        }
        CloseableIterator it = atomset.iterator();
        while (it.hasNext()) {
            mapped.add(this.map((Atom)it.next()));
        }
        it.close();
        return mapped;
    }

    @Override
    public InMemoryAtomSet unmap(InMemoryAtomSet atomset) {
        InMemoryAtomSet mapped;
        try {
            mapped = (InMemoryAtomSet)atomset.getClass().newInstance();
        }
        catch (InstantiationException e) {
            mapped = new DefaultInMemoryAtomSet();
        }
        catch (IllegalAccessException e) {
            mapped = new DefaultInMemoryAtomSet();
        }
        CloseableIterator it = atomset.iterator();
        while (it.hasNext()) {
            mapped.add(this.unmap((Atom)it.next()));
        }
        it.close();
        return mapped;
    }

    @Override
    public Mapper inverse() {
        return this.inverse;
    }
}

