/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.mapper;

import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.RuleSet;
import fr.lirmm.graphik.integraal.api.core.RuleSetException;
import fr.lirmm.graphik.integraal.api.core.mapper.Mapper;
import fr.lirmm.graphik.integraal.core.mapper.MapperRuleConverter;
import fr.lirmm.graphik.util.ShouldNeverHappenedError;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import fr.lirmm.graphik.util.stream.IteratorAdapter;
import fr.lirmm.graphik.util.stream.converter.ConverterIterator;
import java.util.Iterator;

public class MappedRuleSet
implements RuleSet {
    private RuleSet ruleSet;
    private Mapper mapper;
    private MapperRuleConverter ruleUnconverter;
    private MapperRuleConverter ruleConverter;

    public MappedRuleSet(RuleSet ruleSet, Mapper mapper) {
        this.ruleSet = ruleSet;
        this.mapper = mapper;
        this.ruleConverter = new MapperRuleConverter(this.mapper);
        this.ruleUnconverter = new MapperRuleConverter(this.mapper.inverse());
    }

    @Override
    public boolean add(Rule rule) {
        return this.ruleSet.add(this.mapper.map(rule));
    }

    @Override
    public boolean addAll(Iterator<Rule> ruleIterator) {
        try {
            return this.addAll((CloseableIterator<Rule>)new CloseableIteratorAdapter<Rule>(ruleIterator));
        }
        catch (Exception e) {
            throw new ShouldNeverHappenedError(e);
        }
    }

    @Override
    public boolean addAll(CloseableIterator<Rule> ruleIterator) throws RuleSetException {
        return this.ruleSet.addAll(new ConverterIterator<Rule, Rule>(ruleIterator, this.ruleConverter));
    }

    @Override
    public boolean remove(Rule rule) {
        return this.ruleSet.remove(this.mapper.map(rule));
    }

    @Override
    public boolean removeAll(Iterator<Rule> ruleIterator) {
        try {
            return this.removeAll((CloseableIterator<Rule>)new CloseableIteratorAdapter<Rule>(ruleIterator));
        }
        catch (Exception e) {
            throw new ShouldNeverHappenedError(e);
        }
    }

    @Override
    public boolean removeAll(CloseableIterator<Rule> ruleIterator) throws RuleSetException {
        return this.ruleSet.removeAll(new ConverterIterator<Rule, Rule>(ruleIterator, this.ruleConverter));
    }

    @Override
    public boolean contains(Rule rule) {
        return this.ruleSet.contains(this.mapper.map(rule));
    }

    @Override
    public int size() {
        return this.ruleSet.size();
    }

    @Override
    public Iterator<Rule> iterator() {
        return new IteratorAdapter<Rule>(new ConverterIterator<Rule, Rule>(new CloseableIteratorAdapter<Rule>(this.ruleSet.iterator()), this.ruleUnconverter));
    }

    @Override
    public boolean isEmpty() {
        return this.ruleSet.isEmpty();
    }
}

