/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.ruleset;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.RuleSet;
import fr.lirmm.graphik.integraal.core.ruleset.LinkedListRuleSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public class IndexedByBodyPredicatesRuleSet
extends LinkedListRuleSet {
    TreeMap<Predicate, RuleSet> map = new TreeMap();

    public IndexedByBodyPredicatesRuleSet() {
    }

    public IndexedByBodyPredicatesRuleSet(Iterable<Rule> rules) {
        for (Rule r : rules) {
            this.add(r);
        }
    }

    public Iterable<Rule> getRulesByBodyPredicate(Predicate predicate) {
        List<Rule> res = (List<Rule>)((Object)this.map.get(predicate));
        if (res == null) {
            res = Collections.emptyList();
        }
        return res;
    }

    @Override
    public boolean add(Rule rule) {
        super.add(rule);
        for (Atom a : rule.getBody()) {
            this.add(a.getPredicate(), rule);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Rule> c) {
        boolean res = super.addAll(c);
        for (Rule rule : c) {
            for (Atom a : rule.getBody()) {
                this.add(a.getPredicate(), rule);
            }
        }
        return res;
    }

    @Override
    public boolean remove(Rule rule) {
        boolean res = super.remove(rule);
        for (Atom a : rule.getBody()) {
            this.remove(a.getPredicate(), rule);
        }
        return res;
    }

    @Override
    public void clear() {
        super.clear();
        this.map.clear();
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Rule) {
            return this.remove((Rule)o);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean res = false;
        for (Object o : c) {
            res = this.remove(o) || res;
        }
        return res;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean res = super.retainAll(c);
        this.map.clear();
        this.addAll(this);
        return res;
    }

    private void add(Predicate p, Rule r) {
        RuleSet rules = this.map.get(p);
        if (rules == null) {
            rules = new LinkedListRuleSet();
            this.map.put(p, rules);
        }
        rules.add(r);
    }

    private void remove(Predicate p, Rule r) {
        RuleSet rules = this.map.get(p);
        if (rules != null) {
            rules.remove(r);
        }
    }
}

