/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.term;

import fr.lirmm.graphik.integraal.api.core.AbstractTerm;
import fr.lirmm.graphik.integraal.api.core.Literal;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.util.URI;
import fr.lirmm.graphik.util.URIUtils;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

final class DefaultLiteral
extends AbstractTerm
implements Literal {
    private static final long serialVersionUID = -8168240181900479256L;
    private final Object value;
    private final URI datatype;
    private final String identifier;

    public DefaultLiteral(Literal lit) {
        this(lit.getDatatype(), lit.getValue());
    }

    public DefaultLiteral(Object value) {
        boolean test = false;
        Matcher m = null;
        if (value instanceof String) {
            m = URIUtils.LITERAL_PATTERN.matcher((String)value);
            test = m.matches();
        }
        if (test) {
            this.datatype = URIUtils.createURI(m.group(2));
            this.value = m.group(1);
        } else {
            this.datatype = URIUtils.createURI("java:" + StringUtils.reverseDelimited((String)value.getClass().getCanonicalName(), (char)'.'));
            this.value = value;
        }
        this.identifier = "\"" + this.value.toString() + "\"^^<" + this.getDatatype().toString() + ">";
    }

    public DefaultLiteral(URI datatype, Object value) {
        this.datatype = datatype;
        this.value = value;
        this.identifier = "\"" + this.value.toString() + "\"^^<" + this.getDatatype().toString() + ">";
    }

    @Override
    @Deprecated
    public final Term.Type getType() {
        return Term.Type.LITERAL;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getLabel() {
        return this.value.toString();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }
}

