/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.unifier;

import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.unifier.DependencyChecker;
import fr.lirmm.graphik.integraal.api.core.unifier.UnifierAlgorithm;
import fr.lirmm.graphik.integraal.core.ConjunctiveQueryRuleAdapter;
import fr.lirmm.graphik.integraal.core.VariablePrefixSubstitution;
import fr.lirmm.graphik.integraal.core.VariableRemovePrefixSubstitution;
import fr.lirmm.graphik.integraal.core.unifier.UnifierIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorWithoutException;

public class DefaultUnifierAlgorithm
implements UnifierAlgorithm {
    private static DefaultUnifierAlgorithm instance;
    private static Substitution sourceSubstitution;
    private static Substitution targetSubstitution;
    private static Substitution sourceReverseSubstitution;
    private static Substitution targetReverseSubstitution;

    protected DefaultUnifierAlgorithm() {
    }

    public static synchronized DefaultUnifierAlgorithm instance() {
        if (instance == null) {
            instance = new DefaultUnifierAlgorithm();
        }
        return instance;
    }

    public CloseableIteratorWithoutException<Substitution> computePieceUnifier(Rule rule, InMemoryAtomSet query, DependencyChecker ... filters) {
        return new UnifierIterator(rule, (Rule)new ConjunctiveQueryRuleAdapter(query), filters);
    }

    public CloseableIteratorWithoutException<Substitution> computePieceUnifier(Rule rule, Rule target, DependencyChecker ... filters) {
        return new UnifierIterator(rule, target, filters);
    }

    @Override
    public boolean existPieceUnifier(Rule rule, InMemoryAtomSet query, DependencyChecker ... filters) {
        UnifierIterator it = new UnifierIterator(rule, (Rule)new ConjunctiveQueryRuleAdapter(query), true, filters);
        boolean res = it.hasNext();
        it.close();
        return res;
    }

    @Override
    public boolean existPieceUnifier(Rule source, Rule target, DependencyChecker ... filters) {
        UnifierIterator it = new UnifierIterator(source, target, true, filters);
        boolean res = it.hasNext();
        it.close();
        return res;
    }

    public static Substitution getSourceVariablesSubstitution() {
        return sourceSubstitution;
    }

    public static Substitution getTargetVariablesSubstitution() {
        return targetSubstitution;
    }

    public static Substitution getReverseSourceVariablesSubstitution() {
        return sourceReverseSubstitution;
    }

    public static Substitution getReverseTargetVariablesSubstitution() {
        return targetReverseSubstitution;
    }

    static {
        sourceSubstitution = new VariablePrefixSubstitution("S::");
        targetSubstitution = new VariablePrefixSubstitution("T::");
        sourceReverseSubstitution = new VariableRemovePrefixSubstitution("S::");
        targetReverseSubstitution = new VariableRemovePrefixSubstitution("T::");
    }
}

