/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.unifier;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.core.unifier.DependencyChecker;
import fr.lirmm.graphik.integraal.core.factory.DefaultSubstitutionFactory;
import fr.lirmm.graphik.integraal.core.unifier.RuleDependencyUtils;
import fr.lirmm.graphik.integraal.core.unifier.Unifier;
import fr.lirmm.graphik.util.LinkedSet;
import fr.lirmm.graphik.util.stream.AbstractCloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorWithoutException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;

class UnifierIterator
extends AbstractCloseableIterator<Substitution>
implements CloseableIteratorWithoutException<Substitution> {
    Queue<Substitution> unifiers = null;
    private Rule source;
    private Rule target;
    private DependencyChecker[] checkers;
    private long maxSubstitution;

    public UnifierIterator(Rule source, Rule target, DependencyChecker ... checkers) {
        this(source, target, -1L, checkers);
    }

    public UnifierIterator(Rule source, Rule target, boolean checkExists, DependencyChecker ... checkers) {
        this(source, target, checkExists ? 1L : -1L, checkers);
    }

    public UnifierIterator(Rule source, Rule target, long maxSubstitutions, DependencyChecker ... checkers) {
        this.source = source;
        this.target = target;
        this.checkers = checkers;
        this.maxSubstitution = maxSubstitutions;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        if (this.unifiers == null) {
            this.unifiers = new LinkedList<Substitution>(this.computePieceUnifiers(this.source, this.target, this.maxSubstitution));
        }
        return !this.unifiers.isEmpty();
    }

    @Override
    public Substitution next() {
        this.hasNext();
        return this.unifiers.poll();
    }

    public Set<Substitution> computePieceUnifiers(Rule source, Rule target) {
        return this.computePieceUnifiers(source, target, -1L);
    }

    public Set<Substitution> computePieceUnifiers(Rule source, Rule target, boolean exists) {
        return this.computePieceUnifiers(source, target, exists ? 1L : -1L);
    }

    public Set<Substitution> computePieceUnifiers(Rule source, Rule target, long maxSubstitutions) {
        LinkedSet<Substitution> unifiers = new LinkedSet<Substitution>();
        LinkedList<Atom> atomQueue = new LinkedList<Atom>();
        for (Atom a : target.getBody()) {
            atomQueue.add(a);
        }
        long nbAdd = 0L;
        for (Atom a : target.getBody()) {
            LinkedList<Atom> tmp = new LinkedList<Atom>(atomQueue);
            Collection<Substitution> substitutions = this.extendUnifier(source, tmp, a, new Unifier(), maxSubstitutions);
            nbAdd = substitutions.size();
            unifiers.addAll(substitutions);
            if (nbAdd <= 0L || maxSubstitutions <= 0L) continue;
            if ((maxSubstitutions -= nbAdd) < 0L) {
                maxSubstitutions = 0L;
            }
            if (maxSubstitutions != 0L) continue;
            break;
        }
        return unifiers;
    }

    private Collection<Substitution> extendUnifier(Rule rule, Queue<Atom> atomset, Atom pieceElement, Unifier unifier, long maxSubstitutions) {
        boolean notCheckMax;
        atomset.remove(pieceElement);
        unifier.queryPiece.add(pieceElement);
        if (maxSubstitutions == 0L) {
            return Collections.emptySet();
        }
        LinkedList<Substitution> unifierCollection = new LinkedList<Substitution>();
        Set<Variable> frontierVars = rule.getFrontier();
        Set<Variable> existentialVars = rule.getExistentials();
        CloseableIterator it = rule.getHead().iterator();
        long nbAdd = 0L;
        boolean bl = notCheckMax = maxSubstitutions < 0L;
        while (it.hasNext()) {
            Atom atom = (Atom)it.next();
            Substitution u = UnifierIterator.unifier(unifier.s, pieceElement, atom, frontierVars, existentialVars);
            if (u == null) continue;
            unifier = new Unifier(unifier);
            unifier.ruleHeadPiece.add(atom);
            unifier.s = u;
            Atom nextPieceElement = UnifierIterator.getNextPieceElementIfExist(u, atomset, existentialVars);
            if (nextPieceElement == null) {
                if (!RuleDependencyUtils.validateUnifier(this.source, this.target, unifier.s, this.checkers)) continue;
                unifierCollection.add(unifier.s);
                nbAdd = 1L;
            } else {
                Collection<Substitution> substitutions = this.extendUnifier(rule, new LinkedList<Atom>(atomset), nextPieceElement, unifier, maxSubstitutions);
                nbAdd = substitutions.size();
                if (nbAdd == 0L) continue;
                unifierCollection.addAll(substitutions);
            }
            if (notCheckMax || (maxSubstitutions -= nbAdd) > 0L) continue;
            return unifierCollection;
        }
        return unifierCollection;
    }

    private static Atom getNextPieceElementIfExist(Substitution u, Queue<Atom> atomset, Set<Variable> glueVars) {
        for (Atom a : atomset) {
            for (Term t1 : a) {
                for (Term term : glueVars) {
                    if (!u.createImageOf(term).equals(u.createImageOf(t1))) continue;
                    return a;
                }
            }
        }
        return null;
    }

    private static Substitution unifier(Substitution baseUnifier, Atom a1, Atom a2, Set<Variable> frontierVars, Set<Variable> existentialVars) {
        if (!a1.getPredicate().equals(a2.getPredicate())) {
            return null;
        }
        boolean error = false;
        Substitution u = DefaultSubstitutionFactory.instance().createSubstitution();
        u.put(baseUnifier);
        for (int i = 0; i < a1.getPredicate().getArity(); ++i) {
            Term t1 = a1.getTerm(i);
            Term t2 = a2.getTerm(i);
            error = error || !UnifierIterator.compose(u, frontierVars, existentialVars, t1, t2);
        }
        if (error) {
            return null;
        }
        return u;
    }

    private static boolean compose(Substitution u, Set<Variable> frontierVars, Set<Variable> existentials, Term term, Term substitut) {
        Term substitutSubstitut;
        Term termSubstitut = u.createImageOf(term);
        if (!termSubstitut.equals(substitutSubstitut = u.createImageOf(substitut))) {
            if (termSubstitut.isConstant() || existentials.contains(termSubstitut)) {
                Term tmp = termSubstitut;
                termSubstitut = substitutSubstitut;
                substitutSubstitut = tmp;
            }
            for (Term term2 : u.getTerms()) {
                if (!termSubstitut.equals(u.createImageOf(term2)) || UnifierIterator.put(u, frontierVars, existentials, term2, substitutSubstitut)) continue;
                return false;
            }
            if (!UnifierIterator.put(u, frontierVars, existentials, termSubstitut, substitutSubstitut)) {
                return false;
            }
        }
        return true;
    }

    private static boolean put(Substitution u, Set<Variable> frontierVars, Set<Variable> existentials, Term term, Term substitut) {
        if (!term.equals(substitut)) {
            if (term.isConstant() || existentials.contains(term)) {
                return false;
            }
            if (frontierVars.contains(term) && existentials.contains(substitut)) {
                return false;
            }
            u.put((Variable)term, substitut);
        }
        return true;
    }
}

