/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core.unifier;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.core.DefaultVariableGenerator;
import fr.lirmm.graphik.integraal.core.FreshVarSubstitution;
import fr.lirmm.graphik.integraal.core.atomset.AtomSetUtils;
import fr.lirmm.graphik.integraal.core.atomset.DefaultInMemoryAtomSet;
import fr.lirmm.graphik.integraal.core.factory.DefaultRuleFactory;
import fr.lirmm.graphik.integraal.core.unifier.AtomicHeadRule;
import fr.lirmm.graphik.integraal.core.unifier.QueryUnifier;
import fr.lirmm.graphik.integraal.core.unifier.TermPartitionUtils;
import fr.lirmm.graphik.util.Partition;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class UnifierUtils {
    private static DefaultVariableGenerator varGen = new DefaultVariableGenerator("X" + UnifierUtils.class.hashCode());

    private UnifierUtils() {
    }

    public static List<QueryUnifier> getSinglePieceUnifiersNAHR(ConjunctiveQuery q, Rule r, RulesCompilation compilation) {
        return UnifierUtils.getSinglePieceUnifiersNAHR(q, r, compilation, -1L);
    }

    public static List<QueryUnifier> getSinglePieceUnifiersNAHR(ConjunctiveQuery q, Rule r, RulesCompilation compilation, boolean checkExists) {
        return UnifierUtils.getSinglePieceUnifiersNAHR(q, r, compilation, checkExists ? 1L : -1L);
    }

    public static List<QueryUnifier> getSinglePieceUnifiersNAHR(ConjunctiveQuery q, Rule r, RulesCompilation compilation, long maxQueryUnifiers) {
        LinkedList<QueryUnifier> u = new LinkedList<QueryUnifier>();
        if (maxQueryUnifiers == 0L) {
            return u;
        }
        Rule ruleCopy = UnifierUtils.getSafeCopy(r);
        HashMap<Atom, LinkedList<Partition<Term>>> possibleUnification = new HashMap<Atom, LinkedList<Partition<Term>>>();
        for (Atom a : q) {
            for (Atom b : ruleCopy.getHead()) {
                if (!compilation.isMappable(a.getPredicate(), b.getPredicate())) continue;
                Collection<Partition<Term>> unification = compilation.getUnification(a, b);
                for (Partition partition : unification) {
                    if (!TermPartitionUtils.isAdmissible(partition, ruleCopy)) continue;
                    if (possibleUnification.get(a) == null) {
                        possibleUnification.put(a, new LinkedList());
                    }
                    ((LinkedList)possibleUnification.get(a)).add(partition);
                }
            }
        }
        long nbAdd = 0L;
        boolean notCheckMax = maxQueryUnifiers < 0L;
        LinkedList<Atom> atoms = UnifierUtils.getUnifiableAtoms(q, r, compilation);
        for (Atom atom : atoms) {
            LinkedList partitionList = (LinkedList)possibleUnification.get(atom);
            if (partitionList == null) continue;
            Iterator i = partitionList.iterator();
            while (i.hasNext()) {
                Partition unif = (Partition)i.next();
                DefaultInMemoryAtomSet p = new DefaultInMemoryAtomSet();
                p.add(atom);
                Collection<? extends QueryUnifier> queryUnifiers = UnifierUtils.extend(p, unif, possibleUnification, q, ruleCopy, maxQueryUnifiers);
                nbAdd = queryUnifiers.size();
                u.addAll(queryUnifiers);
                i.remove();
                if (notCheckMax || nbAdd == 0L || (maxQueryUnifiers -= nbAdd) > 0L) continue;
                return u;
            }
        }
        return u;
    }

    public static LinkedList<QueryUnifier> getSinglePieceUnifiersAHR(ConjunctiveQuery q, AtomicHeadRule r, RulesCompilation compilation) {
        LinkedList<Atom> unifiableAtoms = UnifierUtils.getUnifiableAtoms(q, r, compilation);
        LinkedList<QueryUnifier> unifiers = new LinkedList<QueryUnifier>();
        Iterator i = unifiableAtoms.iterator();
        while (i.hasNext()) {
            DefaultInMemoryAtomSet p = new DefaultInMemoryAtomSet();
            Rule tmpRule = UnifierUtils.getSafeCopy(r);
            AtomicHeadRule copy = new AtomicHeadRule(tmpRule.getBody(), (Atom)tmpRule.getHead().iterator().next());
            Atom toUnif = (Atom)i.next();
            p.add(toUnif);
            Partition<Term> partition = new Partition<Term>(toUnif.getTerms(), copy.getHead().getAtom().getTerms());
            LinkedList<Term> sep = AtomSetUtils.sep(p, q.getAtomSet());
            LinkedList<Term> sticky = TermPartitionUtils.getStickyVariable(partition, sep, copy);
            InMemoryAtomSet pBar = AtomSetUtils.minus(q.getAtomSet(), p);
            while (partition != null && !sticky.isEmpty()) {
                CloseableIterator ia = pBar.iterator();
                while (partition != null && ia.hasNext()) {
                    Atom a = (Atom)ia.next();
                    Iterator ix = sticky.iterator();
                    while (partition != null && ix.hasNext()) {
                        Term x = (Term)ix.next();
                        if (!a.getTerms().contains(x)) continue;
                        if (compilation.isMappable(a.getPredicate(), copy.getHead().getAtom().getPredicate())) {
                            p.add(a);
                            Partition<Term> part = partition.join(new Partition<Term>(a.getTerms(), copy.getHead().getAtom().getTerms()));
                            if (TermPartitionUtils.isAdmissible(part, copy)) {
                                partition = part;
                                continue;
                            }
                            partition = null;
                            continue;
                        }
                        partition = null;
                    }
                }
                if (partition == null) continue;
                sep = AtomSetUtils.sep(p, q.getAtomSet());
                pBar = AtomSetUtils.minus(q.getAtomSet(), p);
                sticky = TermPartitionUtils.getStickyVariable(partition, sep, copy);
            }
            i.remove();
            if (partition == null) continue;
            QueryUnifier u = new QueryUnifier(p, partition, copy, q);
            unifiers.add(u);
        }
        return unifiers;
    }

    public static LinkedList<Atom> getUnifiableAtoms(ConjunctiveQuery query, Rule r, RulesCompilation compilation) {
        LinkedList<Atom> answer = new LinkedList<Atom>();
        for (Atom a : query) {
            for (Atom b : r.getHead()) {
                if (!compilation.isMappable(a.getPredicate(), b.getPredicate())) continue;
                answer.add(a);
            }
        }
        return answer;
    }

    private static Collection<? extends QueryUnifier> extend(InMemoryAtomSet p, Partition<Term> unif, HashMap<Atom, LinkedList<Partition<Term>>> possibleUnification, ConjunctiveQuery q, Rule r, long maxQueryUnifiers) {
        LinkedList<? extends QueryUnifier> u = new LinkedList<QueryUnifier>();
        LinkedList<Term> sep = AtomSetUtils.sep(p, q.getAtomSet());
        LinkedList<Term> sticky = TermPartitionUtils.getStickyVariable(unif, sep, r);
        if (sticky.isEmpty()) {
            u.add(new QueryUnifier(p, unif, r, q));
        } else {
            InMemoryAtomSet pBar = AtomSetUtils.minus(q.getAtomSet(), p);
            DefaultInMemoryAtomSet pExt = new DefaultInMemoryAtomSet();
            DefaultInMemoryAtomSet toRemove = new DefaultInMemoryAtomSet();
            for (Term t : sticky) {
                pBar.removeAll(toRemove);
                toRemove.clear();
                for (Atom b : pBar) {
                    if (!b.getTerms().contains(t)) continue;
                    pExt.add(b);
                    toRemove.add(b);
                }
            }
            long nbAdd = 0L;
            boolean notCheckMax = maxQueryUnifiers < 0L;
            for (Partition partition : UnifierUtils.preUnifier(pExt, r, possibleUnification)) {
                Partition<Term> part = unif.join(partition);
                if (part != null && TermPartitionUtils.isAdmissible(part, r)) {
                    Collection<? extends QueryUnifier> queryUnifiers = UnifierUtils.extend(AtomSetUtils.union(p, pExt), part, possibleUnification, q, r, maxQueryUnifiers);
                    nbAdd = queryUnifiers.size();
                    u.addAll(queryUnifiers);
                }
                if (notCheckMax || nbAdd == 0L || (maxQueryUnifiers -= nbAdd) > 0L) continue;
                return u;
            }
        }
        return u;
    }

    private static LinkedList<Partition<Term>> preUnifier(InMemoryAtomSet p, Rule r, HashMap<Atom, LinkedList<Partition<Term>>> possibleUnification) {
        LinkedList<Partition<Term>> res = new LinkedList<Partition<Term>>();
        for (Atom a : p) {
            if (possibleUnification.get(a) != null) {
                for (Partition partition : possibleUnification.get(a)) {
                    DefaultInMemoryAtomSet fa = new DefaultInMemoryAtomSet();
                    fa.add(a);
                    InMemoryAtomSet aBar = null;
                    aBar = AtomSetUtils.minus(p, fa);
                    if (!aBar.iterator().hasNext()) {
                        res.add(partition);
                        continue;
                    }
                    for (Partition partition2 : UnifierUtils.preUnifier(aBar, r, possibleUnification)) {
                        Partition<Term> part = partition.join(partition2);
                        if (part == null || !TermPartitionUtils.isAdmissible(part, r)) continue;
                        res.add(part);
                    }
                }
                continue;
            }
            return res;
        }
        return res;
    }

    public static Rule getSafeCopy(Rule rule) {
        FreshVarSubstitution substitution = new FreshVarSubstitution(varGen);
        InMemoryAtomSet body = rule.getBody();
        InMemoryAtomSet head = rule.getHead();
        DefaultInMemoryAtomSet safeBody = new DefaultInMemoryAtomSet();
        DefaultInMemoryAtomSet safeHead = new DefaultInMemoryAtomSet();
        substitution.apply(body, safeBody);
        substitution.apply(head, safeHead);
        return DefaultRuleFactory.instance().create(rule.getLabel(), safeBody, safeHead);
    }
}

