/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.forward_chaining;

import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.Query;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.RuleSet;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.forward_chaining.AbstractDirectChase;
import fr.lirmm.graphik.integraal.api.forward_chaining.ChaseException;
import fr.lirmm.graphik.integraal.api.forward_chaining.ChaseHaltingCondition;
import fr.lirmm.graphik.integraal.api.forward_chaining.DirectRuleApplier;
import fr.lirmm.graphik.integraal.api.homomorphism.Homomorphism;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismWithCompilation;
import fr.lirmm.graphik.integraal.core.ruleset.LinkedListRuleSet;
import fr.lirmm.graphik.integraal.forward_chaining.rule_applier.DefaultRuleApplier;
import fr.lirmm.graphik.integraal.forward_chaining.rule_applier.DefaultRuleApplierWithCompilation;
import java.util.Iterator;

public class BasicChase<T extends AtomSet>
extends AbstractDirectChase<Rule, T> {
    private RuleSet ruleSet;
    private T atomSet;
    private boolean hasNext = true;

    public BasicChase(Iterator<Rule> rules, T atomSet) {
        super(new DefaultRuleApplier());
        this.atomSet = atomSet;
        this.ruleSet = new LinkedListRuleSet(rules);
    }

    public BasicChase(Iterable<Rule> rules, T atomSet) {
        super(new DefaultRuleApplier());
        this.atomSet = atomSet;
        this.ruleSet = new LinkedListRuleSet(rules);
    }

    public BasicChase(Iterator<Rule> rules, T atomSet, DirectRuleApplier<? super Rule, ? super T> ruleApplier) {
        super(ruleApplier);
        this.atomSet = atomSet;
        this.ruleSet = new LinkedListRuleSet(rules);
    }

    public BasicChase(Iterable<Rule> rules, T atomSet, DirectRuleApplier<? super Rule, ? super T> ruleApplier) {
        this(rules.iterator(), (T)atomSet, (DirectRuleApplier<Rule, ? super T>)ruleApplier);
    }

    public BasicChase(Iterable<Rule> rules, T atomSet, Homomorphism<Query, ? super T> solver) {
        this(rules, atomSet, new DefaultRuleApplier<T>(solver));
    }

    public BasicChase(Iterable<Rule> rules, T atomSet, ChaseHaltingCondition haltingCondition) {
        this(rules, atomSet, new DefaultRuleApplier(haltingCondition));
    }

    public BasicChase(Iterable<Rule> rules, T atomSet, Homomorphism<Query, ? super T> solver, ChaseHaltingCondition haltingCondition) {
        this(rules, atomSet, new DefaultRuleApplier<T>(solver, haltingCondition));
    }

    public BasicChase(Iterable<Rule> rules, T atomSet, RulesCompilation compilation) {
        this(rules, atomSet, new DefaultRuleApplierWithCompilation(compilation));
    }

    public BasicChase(Iterator<Rule> rules, T atomSet, RulesCompilation compilation) {
        this(rules, atomSet, new DefaultRuleApplierWithCompilation(compilation));
    }

    public BasicChase(Iterable<Rule> rules, T atomSet, RulesCompilation compilation, HomomorphismWithCompilation<? super Query, ? super T> h) {
        this(rules, atomSet, new DefaultRuleApplierWithCompilation<T>(h, compilation));
    }

    @Override
    public void next() throws ChaseException {
        try {
            this.hasNext = false;
            for (Rule rule : this.ruleSet) {
                String key = null;
                if (this.getProfiler().isProfilingEnabled()) {
                    this.getProfiler().start("saturationTime");
                    this.getProfiler().trace(rule.toString());
                    key = "Rule " + rule.getLabel() + " application time";
                    this.getProfiler().clear(key);
                    this.getProfiler().start(key);
                }
                boolean val = this.getRuleApplier().apply(rule, this.atomSet);
                boolean bl = this.hasNext = this.hasNext || val;
                if (!this.getProfiler().isProfilingEnabled()) continue;
                this.getProfiler().stop(key);
                this.getProfiler().stop("saturationTime");
            }
        }
        catch (Exception e) {
            throw new ChaseException("An error occured during saturation step.", e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }
}

