/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.forward_chaining;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.GraphOfRuleDependencies;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.unifier.DependencyChecker;
import fr.lirmm.graphik.integraal.api.forward_chaining.AbstractChase;
import fr.lirmm.graphik.integraal.api.forward_chaining.ChaseException;
import fr.lirmm.graphik.integraal.api.forward_chaining.RuleApplier;
import fr.lirmm.graphik.integraal.core.grd.DefaultGraphOfRuleDependencies;
import fr.lirmm.graphik.integraal.forward_chaining.rule_applier.DefaultRuleApplierWithCompilation;
import fr.lirmm.graphik.integraal.forward_chaining.rule_applier.RestrictedChaseRuleApplier;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class ChaseWithGRD<T extends AtomSet>
extends AbstractChase<Rule, T> {
    private GraphOfRuleDependencies grd;
    private T atomSet;
    private Instant timeout_endTime;
    private TemporalAmount timeout_duration;
    private int checkTimeoutEvery = 50000;
    private Queue<Rule> queue = new LinkedList<Rule>();

    public ChaseWithGRD(GraphOfRuleDependencies grd, T atomSet, RuleApplier<Rule, ? super T> ruleApplier) {
        super(ruleApplier);
        this.grd = grd;
        this.atomSet = atomSet;
        for (Rule r : grd.getRules()) {
            this.queue.add(r);
        }
        this.setTimeout(Duration.ofMinutes(1L));
    }

    public ChaseWithGRD(GraphOfRuleDependencies grd, T atomSet) {
        this(grd, atomSet, new RestrictedChaseRuleApplier());
    }

    public ChaseWithGRD(Iterator<Rule> rules, T atomSet) {
        this(new DefaultGraphOfRuleDependencies(rules, new DependencyChecker[0]), atomSet);
    }

    public ChaseWithGRD(Iterable<Rule> rules, T atomSet, RulesCompilation compilation) throws ChaseException, IOException {
        this(new DefaultGraphOfRuleDependencies(rules, compilation), atomSet, new DefaultRuleApplierWithCompilation(compilation));
    }

    public ChaseWithGRD(Iterator<Rule> rules, T atomSet, RulesCompilation compilation) throws ChaseException, IOException {
        this(new DefaultGraphOfRuleDependencies(rules, compilation), atomSet, new DefaultRuleApplierWithCompilation(compilation));
    }

    public void checkTimeoutEvery(int val) {
        this.checkTimeoutEvery = val;
    }

    public void setTimeout(TemporalAmount duration) {
        this.timeout_duration = duration;
    }

    @Override
    public void next() throws ChaseException {
        LinkedList<Rule> newQueue = new LinkedList<Rule>();
        LinkedList<Atom> newAtomSet = new LinkedList<Atom>();
        if (this.timeout_endTime == null) {
            this.timeout_endTime = Instant.now().plus(this.timeout_duration);
        }
        try {
            while (!this.queue.isEmpty()) {
                Rule rule = this.queue.poll();
                if (rule == null) continue;
                CloseableIterator<Atom> it = this.getRuleApplier().delegatedApply(rule, this.atomSet);
                if (!it.hasNext()) {
                    it.close();
                    continue;
                }
                long timeout_cnt = this.checkTimeoutEvery;
                while (it.hasNext()) {
                    newAtomSet.add(it.next());
                    if (--timeout_cnt != 0L) continue;
                    if (Instant.now().isAfter(this.timeout_endTime)) {
                        throw new ChaseException("Timeout; allowed time: " + String.valueOf(this.timeout_duration));
                    }
                    timeout_cnt = this.checkTimeoutEvery;
                }
                it.close();
                for (Rule triggeredRule : this.grd.getTriggeredRules(rule)) {
                    if (newQueue.contains(triggeredRule)) continue;
                    newQueue.add(triggeredRule);
                }
            }
            this.queue = newQueue;
            this.atomSet.addAll(new CloseableIteratorAdapter(newAtomSet.iterator()));
        }
        catch (Exception e) {
            throw new ChaseException("An error occur pending saturation step.", e);
        }
        if (!this.hasNext()) {
            this.timeout_endTime = null;
        }
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }
}

