/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.forward_chaining;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.GraphOfRuleDependencies;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.unifier.DependencyChecker;
import fr.lirmm.graphik.integraal.api.forward_chaining.AbstractChase;
import fr.lirmm.graphik.integraal.api.forward_chaining.ChaseException;
import fr.lirmm.graphik.integraal.api.forward_chaining.RuleApplicationException;
import fr.lirmm.graphik.integraal.api.forward_chaining.RuleApplier;
import fr.lirmm.graphik.integraal.core.grd.DefaultGraphOfRuleDependencies;
import fr.lirmm.graphik.integraal.forward_chaining.ChaseWithGRD;
import fr.lirmm.graphik.integraal.forward_chaining.rule_applier.DefaultRuleApplierWithCompilation;
import fr.lirmm.graphik.integraal.forward_chaining.rule_applier.RestrictedChaseRuleApplier;
import fr.lirmm.graphik.util.graph.scc.StronglyConnectedComponentsGraph;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class SccChase<T extends AtomSet>
extends AbstractChase<Rule, T> {
    private GraphOfRuleDependencies grd;
    private T atomSet;
    private List<Atom> tmpAtom;
    private Queue<Rule> queue = new LinkedList<Rule>();
    private List<Integer>[] layers;
    int level = -1;
    int levelmax;
    StronglyConnectedComponentsGraph<Rule> sccg;

    public SccChase(GraphOfRuleDependencies grd, T atomSet, RuleApplier<Rule, ? super T> ruleApplier) {
        super(ruleApplier);
        this.grd = grd;
        this.atomSet = atomSet;
        for (Rule r : grd.getRules()) {
            this.queue.add(r);
        }
        this.init();
    }

    public SccChase(Iterator<Rule> rules, T atomSet, RuleApplier<Rule, ? super T> ruleApplier) {
        this(new DefaultGraphOfRuleDependencies(rules, new DependencyChecker[0]), (T)atomSet, ruleApplier);
    }

    public SccChase(GraphOfRuleDependencies grd, T atomSet) {
        this(grd, atomSet, new RestrictedChaseRuleApplier());
    }

    public SccChase(Iterator<Rule> rules, T atomSet) {
        this(new DefaultGraphOfRuleDependencies(rules, new DependencyChecker[0]), atomSet);
    }

    public SccChase(Iterator<Rule> rules, T atomSet, RulesCompilation compilation) {
        this(new DefaultGraphOfRuleDependencies(rules, compilation), atomSet, new DefaultRuleApplierWithCompilation(compilation));
    }

    private final void init() {
        this.sccg = this.grd.getStronglyConnectedComponentsGraph();
        int[] sccLayer = this.sccg.computeLayers(this.sccg.getSources(), true);
        this.layers = new List[sccLayer.length];
        this.levelmax = -1;
        for (int scc = 0; scc < sccLayer.length; ++scc) {
            List<Integer> l;
            if (sccLayer[scc] > this.levelmax) {
                this.levelmax = sccLayer[scc];
            }
            if ((l = this.layers[sccLayer[scc]]) == null) {
                this.layers[sccLayer[scc]] = l = new LinkedList<Integer>();
            }
            l.add(scc);
        }
    }

    @Override
    public void next() throws ChaseException {
        ++this.level;
        this.tmpAtom = new LinkedList<Atom>();
        for (Integer scc : this.layers[this.level]) {
            Set<Rule> component = this.sccg.getComponent(scc);
            GraphOfRuleDependencies subGraph = this.grd.getSubGraph(component);
            if (component.size() == 1 && !subGraph.hasCircuit()) {
                try {
                    CloseableIterator<Atom> it = this.getRuleApplier().delegatedApply(component.iterator().next(), this.atomSet);
                    while (it.hasNext()) {
                        this.tmpAtom.add(it.next());
                    }
                    it.close();
                    continue;
                }
                catch (RuleApplicationException e) {
                    throw new ChaseException("", e);
                }
                catch (IteratorException e) {
                    throw new ChaseException("", e);
                }
            }
            ChaseWithGRD<T> chase = new ChaseWithGRD<T>(subGraph, this.atomSet, this.getRuleApplier());
            chase.execute();
        }
        try {
            this.atomSet.addAll(new CloseableIteratorAdapter<Atom>(this.tmpAtom.iterator()));
        }
        catch (AtomSetException e) {
            throw new ChaseException("", e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.level < this.levelmax;
    }
}

