/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.forward_chaining.halting_condition;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.forward_chaining.ChaseHaltingCondition;
import fr.lirmm.graphik.integraal.api.homomorphism.Homomorphism;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismFactoryException;
import fr.lirmm.graphik.integraal.core.factory.DefaultConjunctiveQueryFactory;
import fr.lirmm.graphik.integraal.core.term.DefaultTermFactory;
import fr.lirmm.graphik.integraal.homomorphism.SmartHomomorphism;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class FrontierRestrictedChaseHaltingCondition
implements ChaseHaltingCondition {
    private Map<Rule, Integer> ruleIndex = new TreeMap<Rule, Integer>();
    private int _currentRuleIndex = 0;
    Homomorphism<? super ConjunctiveQuery, AtomSet> solver;

    public FrontierRestrictedChaseHaltingCondition() {
        this(SmartHomomorphism.instance());
    }

    public FrontierRestrictedChaseHaltingCondition(Homomorphism<? super ConjunctiveQuery, AtomSet> solver) {
        this.solver = solver;
    }

    @Override
    public CloseableIterator<Atom> apply(Rule rule, Substitution substitution, AtomSet data) throws HomomorphismFactoryException, HomomorphismException {
        if (this.ruleIndex.get(rule) == null) {
            this.ruleIndex.put(rule, this._currentRuleIndex++);
        }
        int index = this.ruleIndex.get(rule);
        StringBuilder frontierSb = new StringBuilder();
        TreeSet<Variable> frontierSet = new TreeSet<Variable>(rule.getFrontier());
        for (Term term : frontierSet) {
            frontierSb.append("_");
            frontierSb.append(term.getLabel());
            frontierSb.append("-");
            frontierSb.append(substitution.createImageOf(term).getLabel());
        }
        String frontier = frontierSb.toString();
        for (Variable t : rule.getExistentials()) {
            substitution.put(t, DefaultTermFactory.instance().createConstant("f_" + index + "_" + String.valueOf(t.getIdentifier()) + frontier));
        }
        ConjunctiveQuery conjunctiveQuery = DefaultConjunctiveQueryFactory.instance().create(rule.getHead());
        if (this.solver.exist(conjunctiveQuery, data, substitution)) {
            return new CloseableIteratorAdapter<Atom>(Collections.emptyList().iterator());
        }
        return substitution.createImageOf(rule.getHead()).iterator();
    }
}

