/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.core.factory.DefaultSubstitutionFactory;
import fr.lirmm.graphik.integraal.homomorphism.AbstractHomomorphismWithCompilation;
import fr.lirmm.graphik.integraal.homomorphism.Atom2SubstitutionConverter;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import fr.lirmm.graphik.util.stream.CloseableIteratorAggregator;
import fr.lirmm.graphik.util.stream.Iterators;
import fr.lirmm.graphik.util.stream.converter.ConverterCloseableIterator;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.commons.lang3.tuple.Pair;

public class AtomicQueryHomomorphism
extends AbstractHomomorphismWithCompilation<ConjunctiveQuery, AtomSet> {
    private static final AtomicQueryHomomorphism INSTANCE = new AtomicQueryHomomorphism();

    public static AtomicQueryHomomorphism instance() {
        return INSTANCE;
    }

    private AtomicQueryHomomorphism() {
    }

    @Override
    public CloseableIterator<Substitution> execute(ConjunctiveQuery q, AtomSet a, Substitution s) throws HomomorphismException {
        Atom atom = (Atom)q.getAtomSet().iterator().next();
        try {
            Atom queryAtom = s.createImageOf(atom);
            if (queryAtom.getVariables().isEmpty()) {
                if (a.contains(queryAtom)) {
                    Substitution newSub = DefaultSubstitutionFactory.instance().createSubstitution();
                    for (Term t : q.getAnswerVariables()) {
                        if (!t.isVariable()) continue;
                        newSub.put((Variable)t, s.createImageOf(t));
                    }
                    return new CloseableIteratorAdapter<Substitution>(Collections.singleton(newSub).iterator());
                }
                return Iterators.emptyIterator();
            }
            return new ConverterCloseableIterator<Atom, Substitution>(a.match(atom, s), new Atom2SubstitutionConverter(atom, q.getAnswerVariables()));
        }
        catch (AtomSetException e) {
            throw new HomomorphismException(e);
        }
    }

    @Override
    public CloseableIterator<Substitution> execute(ConjunctiveQuery q, AtomSet a, RulesCompilation rc, Substitution s) throws HomomorphismException {
        Atom atom = (Atom)q.getAtomSet().iterator().next();
        try {
            Atom queryAtom = s.createImageOf(atom);
            if (queryAtom.getVariables().isEmpty()) {
                boolean contains = false;
                for (Pair<Atom, Substitution> pair : rc.getRewritingOf(queryAtom)) {
                    if (!a.contains((Atom)pair.getLeft())) continue;
                    contains = true;
                    break;
                }
                if (contains) {
                    Substitution newSub = DefaultSubstitutionFactory.instance().createSubstitution();
                    for (Term t : q.getAnswerVariables()) {
                        if (!t.isVariable()) continue;
                        newSub.put((Variable)t, s.createImageOf(t));
                    }
                    return new CloseableIteratorAdapter<Substitution>(Collections.singleton(newSub).iterator());
                }
                return Iterators.emptyIterator();
            }
            LinkedList<ConverterCloseableIterator<Atom, Substitution>> iteratorsList = new LinkedList<ConverterCloseableIterator<Atom, Substitution>>();
            for (Pair<Atom, Substitution> pair : rc.getRewritingOf(atom)) {
                iteratorsList.add(new ConverterCloseableIterator<Atom, Substitution>(a.match((Atom)pair.getLeft(), s), new Atom2SubstitutionConverter((Atom)pair.getLeft(), q.getAnswerVariables(), (Substitution)pair.getRight())));
            }
            return new CloseableIteratorAggregator<Substitution>(new CloseableIteratorAdapter(iteratorsList.iterator()));
        }
        catch (AtomSetException e) {
            throw new HomomorphismException(e);
        }
    }
}

