/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.api.homomorphism.PreparedExistentialHomomorphism;
import fr.lirmm.graphik.integraal.core.HashMapSubstitution;
import fr.lirmm.graphik.integraal.homomorphism.BacktrackException;
import fr.lirmm.graphik.integraal.homomorphism.BacktrackIteratorData;
import fr.lirmm.graphik.integraal.homomorphism.Var;
import fr.lirmm.graphik.integraal.homomorphism.backjumping.BackJumping;
import fr.lirmm.graphik.integraal.homomorphism.bootstrapper.Bootstrapper;
import fr.lirmm.graphik.integraal.homomorphism.forward_checking.ForwardChecking;
import fr.lirmm.graphik.integraal.homomorphism.scheduler.Scheduler;
import fr.lirmm.graphik.integraal.homomorphism.utils.BacktrackUtils;
import fr.lirmm.graphik.integraal.homomorphism.utils.HomomorphismIteratorChecker;
import fr.lirmm.graphik.util.profiler.NoProfiler;
import fr.lirmm.graphik.util.profiler.Profilable;
import fr.lirmm.graphik.util.profiler.Profiler;
import fr.lirmm.graphik.util.stream.AbstractCloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

class BacktrackIterator
extends AbstractCloseableIterator<Substitution>
implements CloseableIterator<Substitution>,
Profilable {
    private BacktrackIteratorData data;
    private Substitution initialSubstitution;
    private Substitution next = null;
    private Var[] vars;
    private int level;
    private boolean goBack;
    private Profiler profiler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BacktrackIterator(BacktrackIteratorData data, Substitution initialSubstitution) throws HomomorphismException {
        int i;
        BacktrackIteratorData backtrackIteratorData = this.data = data;
        synchronized (backtrackIteratorData) {
            if (this.data.isOpen) {
                throw new HomomorphismException("Prepared Homomorphism already in use");
            }
            this.data.isOpen = true;
        }
        this.vars = new Var[this.data.varsOrder.length];
        for (i = 0; i < this.vars.length; ++i) {
            this.vars[i] = new Var(this.data.varsOrder[i]);
        }
        for (i = 0; i < this.data.varsOrder.length; ++i) {
            this.vars[i].preAtomsFixed = new LinkedList<Atom>();
            for (Atom a : this.data.varsOrder[i].preAtoms) {
                this.vars[i].preAtomsFixed.add(initialSubstitution.createImageOf(a));
            }
            this.vars[i].postAtomsFixed = new LinkedList<Atom>();
            for (Atom a : this.data.varsOrder[i].postAtoms) {
                this.vars[i].postAtomsFixed.add(initialSubstitution.createImageOf(a));
            }
        }
        this.profiler = data.profiler;
        this.initialSubstitution = initialSubstitution;
        this.level = 0;
        this.goBack = false;
    }

    public BacktrackIterator(InMemoryAtomSet query, Collection<InMemoryAtomSet> negParts, AtomSet data, List<Term> ans, Scheduler scheduler, Bootstrapper bootstrapper, ForwardChecking fc, BackJumping bj, RulesCompilation compilation, Substitution s, Profiler profiler) throws HomomorphismException {
        this(new BacktrackIteratorData(query, s.getTerms(), negParts, data, ans, scheduler, bootstrapper, fc, bj, compilation, profiler), s);
    }

    public BacktrackIterator(InMemoryAtomSet h, Collection<InMemoryAtomSet> negParts, AtomSet g, List<Term> ans, Scheduler scheduler, Bootstrapper boostrapper, ForwardChecking fc, BackJumping bj, RulesCompilation compilation, Substitution s) throws HomomorphismException {
        this(h, negParts, g, ans, scheduler, boostrapper, fc, bj, compilation, s, NoProfiler.instance());
    }

    @Override
    public boolean hasNext() throws IteratorException {
        if (this.next == null) {
            try {
                this.next = this.computeNext();
            }
            catch (BacktrackException e) {
                this.next = null;
                throw new IteratorException("An errors occurs during backtrack iteration", e);
            }
        }
        return this.next != null;
    }

    @Override
    public Substitution next() throws IteratorException {
        Substitution tmp = null;
        if (this.hasNext()) {
            tmp = this.next;
            this.next = null;
        }
        return tmp;
    }

    @Override
    public void close() {
        for (int i = 1; i < this.data.varsOrder.length; ++i) {
            if (this.vars[i].domain == null) continue;
            this.vars[i].domain.close();
        }
        this.data.isOpen = false;
    }

    private Substitution computeNext() throws BacktrackException {
        if (this.profiler != null) {
            this.profiler.start("backtrackingTime");
        }
        try {
            if (this.level == 0) {
                if (BacktrackUtils.isHomomorphism(this.data.varsOrder[this.level].preAtoms, this.data.data, this.initialSubstitution, this.data.index, this.vars, this.data.compilation)) {
                    if (this.existNegParts()) {
                        this.data.bj.success();
                        this.backtrack(false);
                    } else {
                        ++this.level;
                    }
                } else {
                    --this.level;
                }
            }
            while (this.level > 0) {
                this.profiler.incr("#calls", 1);
                if (this.level > this.data.levelMax) {
                    Substitution sol = this.solutionFound(this.data.ans);
                    this.data.bj.success();
                    this.backtrack(false);
                    if (this.profiler != null) {
                        this.profiler.stop("backtrackingTime");
                    }
                    return sol;
                }
                if (this.goBack) {
                    if (this.hasMoreValues(this.currentVar(), this.data.data)) {
                        this.goBack = false;
                        ++this.level;
                        continue;
                    }
                    this.backtrack(true);
                    continue;
                }
                if (this.getFirstValue(this.currentVar(), this.data.data)) {
                    ++this.level;
                    continue;
                }
                this.backtrack(true);
            }
        }
        catch (AtomSetException e) {
            throw new BacktrackException("Exception during backtracking", e);
        }
        --this.level;
        if (this.profiler != null) {
            this.profiler.stop("backtrackingTime");
        }
        return null;
    }

    private void backtrack(boolean failure) {
        int previousLevel = failure ? this.data.bj.previousLevel(this.currentVar().shared, this.vars) : this.currentVar().shared.previousLevel;
        this.goBack = true;
        while (this.level > previousLevel) {
            this.vars[this.level].image = null;
            --this.level;
        }
    }

    private boolean existNegParts() throws BacktrackException {
        Substitution s = this.currentSubstitution(this.vars);
        s.put(this.initialSubstitution);
        for (PreparedExistentialHomomorphism negPart : this.currentVar().shared.negatedPartsToCheck) {
            try {
                if (!negPart.exist(s)) continue;
                this.data.bj.success();
                return true;
            }
            catch (HomomorphismException e) {
                throw new BacktrackException("Error while checking anegated part: ", e);
            }
        }
        return false;
    }

    private Substitution solutionFound(List<Term> ans) {
        HashMapSubstitution s = new HashMapSubstitution();
        for (Term t : ans) {
            Integer idx;
            if (!t.isVariable() || (idx = this.data.index.get((Variable)t)) == null) continue;
            Var v = this.vars[idx];
            s.put(v.shared.value, v.image);
        }
        return s;
    }

    private Substitution currentSubstitution(Var[] vars) {
        HashMapSubstitution s = new HashMapSubstitution();
        for (int i = 1; i <= this.level; ++i) {
            s.put(vars[i].shared.value, vars[i].image);
        }
        return s;
    }

    private boolean getFirstValue(Var var, AtomSet g) throws BacktrackException {
        var.domain = this.data.fc.isInit(this.level) ? this.data.fc.getCandidatsIterator(g, var, this.initialSubstitution, this.data.index, this.vars, this.data.compilation) : new HomomorphismIteratorChecker(var, this.data.bootstrapper.exec(var.shared, var.preAtomsFixed, var.postAtomsFixed, g, this.data.compilation), var.shared.preAtoms, g, this.initialSubstitution, this.data.index, this.vars, this.data.compilation);
        return this.hasMoreValues(var, g);
    }

    private boolean hasMoreValues(Var var, AtomSet g) throws BacktrackException {
        try {
            while (var.domain.hasNext()) {
                this.data.bj.level(var.shared.level);
                var.image = var.domain.next();
                if (!this.data.scheduler.isAllowed(var, var.image) || !this.data.fc.checkForward(var, g, this.initialSubstitution, this.data.index, this.vars, this.data.compilation) || this.existNegParts()) continue;
                return true;
            }
        }
        catch (IteratorException e) {
            throw new BacktrackException("An exception occurs during data iteration", e);
        }
        var.domain.close();
        return false;
    }

    private Var currentVar() {
        return this.vars[this.level];
    }

    @Override
    public void setProfiler(Profiler profiler) {
        if (profiler == null) {
            profiler = NoProfiler.instance();
        }
        this.profiler = profiler;
        this.data.bootstrapper.setProfiler(profiler);
        this.data.scheduler.setProfiler(profiler);
        this.data.fc.setProfiler(profiler);
        this.data.bj.setProfiler(profiler);
    }

    @Override
    public Profiler getProfiler() {
        return this.profiler;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n").append("\t{query: ").append(this.data.query);
        for (InMemoryAtomSet negPart : this.data.negParts) {
            sb.append("\u2227\u00ac").append(negPart);
        }
        sb.append("},\n\t{level: ").append(this.level).append("},\n\t{\n");
        int i = 0;
        for (Var v : this.vars) {
            sb.append("\t\t");
            sb.append(i == this.level ? (char)'*' : ' ');
            String s = v.toString();
            sb.append(s.substring(0, s.length() - 1)).append("->").append(v.image);
            sb.append(v.shared.negatedPartsToCheck.isEmpty() ? "   " : " \u00ac ");
            sb.append("\tFC{");
            this.data.fc.append(sb, i).append("}");
            this.data.bj.append(sb, i).append(" ");
            sb.append(this.data.scheduler.getInfos(v));
            sb.append("\n");
            ++i;
        }
        sb.append("\t}\n}\n");
        return sb.toString();
    }
}

