/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism.backjumping;

import fr.lirmm.graphik.integraal.homomorphism.Var;
import fr.lirmm.graphik.integraal.homomorphism.VarSharedData;
import fr.lirmm.graphik.integraal.homomorphism.backjumping.BackJumping;
import fr.lirmm.graphik.util.profiler.AbstractProfilable;
import java.util.SortedSet;
import java.util.TreeSet;

public class GraphBaseBackJumping
extends AbstractProfilable
implements BackJumping {
    private VarData[] data;

    @Override
    public void init(VarSharedData[] vars) {
        this.data = new VarData[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            this.data[vars[i].level] = new VarData();
        }
    }

    @Override
    public void clear() {
        for (VarData d : this.data) {
            d.clear();
        }
    }

    @Override
    public void success() {
        for (int i = 0; i < this.data.length - 1; ++i) {
            this.data[i].success = true;
        }
    }

    @Override
    public void level(int level) {
        this.data[level].success = false;
    }

    @Override
    public int previousLevel(VarSharedData var, Var[] vars) {
        int ret = var.previousLevel;
        VarSharedData v = null;
        VarSharedData y = null;
        if (!var.preVars.isEmpty()) {
            v = (VarSharedData)var.preVars.last();
        }
        if (!this.data[var.level].backjumpSet.isEmpty()) {
            y = this.data[var.level].backjumpSet.last();
            if (v != null && v.compareTo(y) < 0) {
                v = y;
            }
        }
        if (v != null && !this.data[v.level].success) {
            this.data[v.level].backjumpSet.addAll(var.preVars);
            this.data[v.level].backjumpSet.addAll(this.data[var.level].backjumpSet);
            this.data[v.level].backjumpSet.remove(v);
            if (this.getProfiler().isProfilingEnabled()) {
                this.getProfiler().incr("#backjumps", 1);
                this.getProfiler().incr("#varsBackjumped", var.level - v.level);
            }
            ret = v.level;
        }
        this.data[var.level].backjumpSet.clear();
        return ret;
    }

    @Override
    public void addNeighborhoodToBackjumpSet(VarSharedData from, VarSharedData to) {
        for (VarSharedData v : from.preVars) {
            if (v.level >= to.level) continue;
            this.data[to.level].backjumpSet.add(v);
        }
    }

    @Override
    public StringBuilder append(StringBuilder sb, int level) {
        sb.append("\tBJSet{");
        for (VarSharedData v : this.data[level].backjumpSet) {
            sb.append(v.value);
            sb.append(", ");
        }
        return sb.append("}");
    }

    private static class VarData {
        public SortedSet<VarSharedData> backjumpSet = new TreeSet<VarSharedData>();
        public boolean success = false;

        private VarData() {
        }

        public void clear() {
            this.backjumpSet.clear();
            this.success = false;
        }
    }
}

