/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism.bootstrapper;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.homomorphism.VarSharedData;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

class BootstrapperUtils {
    private BootstrapperUtils() {
    }

    public static Set<Term> computeCandidatesOverRewritings(Atom a, VarSharedData v, AtomSet data, RulesCompilation compilation) throws AtomSetException, IteratorException {
        HashSet<Term> terms = new HashSet<Term>();
        for (Pair<Atom, Substitution> rew : compilation.getRewritingOf(a)) {
            Atom im = (Atom)rew.getLeft();
            Substitution sub = (Substitution)rew.getRight();
            Predicate predicate = im.getPredicate();
            int pos = im.indexOf(sub.createImageOf(v.value));
            CloseableIterator<Term> it = data.termsByPredicatePosition(predicate, pos);
            while (it.hasNext()) {
                terms.add(it.next());
            }
        }
        return terms;
    }
}

