/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism.bootstrapper;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.homomorphism.BacktrackException;
import fr.lirmm.graphik.integraal.homomorphism.VarSharedData;
import fr.lirmm.graphik.integraal.homomorphism.bootstrapper.Bootstrapper;
import fr.lirmm.graphik.util.profiler.AbstractProfilable;
import fr.lirmm.graphik.util.stream.AbstractCloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAggregator;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultBootstrapper
extends AbstractProfilable
implements Bootstrapper {
    private static DefaultBootstrapper instance;

    protected DefaultBootstrapper() {
    }

    public static synchronized DefaultBootstrapper instance() {
        if (instance == null) {
            instance = new DefaultBootstrapper();
        }
        return instance;
    }

    @Override
    public CloseableIterator<Term> exec(final VarSharedData v, Collection<Atom> preAtoms, Collection<Atom> postAtoms, final AtomSet data, RulesCompilation compilation) throws BacktrackException {
        Iterator<Atom> it = postAtoms.iterator();
        if (it.hasNext()) {
            Atom a = it.next();
            final Iterator<Pair<Atom, Substitution>> rewritingOf = compilation.getRewritingOf(a).iterator();
            AbstractCloseableIterator<CloseableIterator<Term>> metaIt = new AbstractCloseableIterator<CloseableIterator<Term>>(this){
                CloseableIterator<Term> next = null;

                @Override
                public void close() {
                    if (this.next != null) {
                        this.next.close();
                    }
                }

                @Override
                public boolean hasNext() throws IteratorException {
                    try {
                        if (this.next == null && rewritingOf.hasNext()) {
                            Pair rew = (Pair)rewritingOf.next();
                            Atom im = (Atom)rew.getLeft();
                            Predicate predicate = im.getPredicate();
                            int pos = im.indexOf(((Substitution)rew.getRight()).createImageOf(v.value));
                            this.next = data.termsByPredicatePosition(predicate, pos);
                        }
                    }
                    catch (AtomSetException e) {
                        throw new IteratorException("An errors occurs while getting terms by predicate position", e);
                    }
                    return this.next != null;
                }

                @Override
                public CloseableIterator<Term> next() throws IteratorException {
                    if (this.next == null) {
                        this.hasNext();
                    }
                    CloseableIterator<Term> ret = this.next;
                    this.next = null;
                    return ret;
                }
            };
            return new CloseableIteratorAggregator<Term>(metaIt);
        }
        try {
            return data.termsIterator();
        }
        catch (AtomSetException e) {
            throw new BacktrackException(e);
        }
    }
}

