/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism.bootstrapper;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.Constant;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.store.Store;
import fr.lirmm.graphik.integraal.homomorphism.BacktrackException;
import fr.lirmm.graphik.integraal.homomorphism.VarSharedData;
import fr.lirmm.graphik.integraal.homomorphism.bootstrapper.Bootstrapper;
import fr.lirmm.graphik.integraal.homomorphism.bootstrapper.BootstrapperUtils;
import fr.lirmm.graphik.integraal.homomorphism.bootstrapper.StarBootstrapper;
import fr.lirmm.graphik.integraal.homomorphism.utils.ProbaUtils;
import fr.lirmm.graphik.util.profiler.AbstractProfilable;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class StatBootstrapper
extends AbstractProfilable
implements Bootstrapper {
    private static StatBootstrapper instance;
    private static Bootstrapper fallback;

    protected StatBootstrapper() {
    }

    public static synchronized StatBootstrapper instance() {
        if (instance == null) {
            instance = new StatBootstrapper();
        }
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CloseableIterator<Term> exec(VarSharedData v, Collection<Atom> preAtoms, Collection<Atom> postAtoms, AtomSet data, RulesCompilation rc) throws BacktrackException {
        if (!(data instanceof Store)) {
            return fallback.exec(v, preAtoms, postAtoms, data, rc);
        }
        Store store = (Store)data;
        Set<Object> terms = null;
        if (this.getProfiler() != null) {
            this.getProfiler().start("BootstrapTime");
            this.getProfiler().start("BootstrapTimeFirstPart");
        }
        Set<Constant> constants = null;
        Atom aa = null;
        for (Atom atom : postAtoms) {
            if (constants != null && !constants.isEmpty()) continue;
            constants = atom.getConstants();
            aa = atom;
        }
        for (Atom atom : preAtoms) {
            if (constants != null && !constants.isEmpty()) continue;
            constants = atom.getConstants();
            aa = atom;
        }
        try {
            if (constants != null && !constants.isEmpty()) {
                terms = new HashSet();
                for (Pair<Atom, Substitution> pair : rc.getRewritingOf(aa)) {
                    int pos = ((Atom)pair.getLeft()).indexOf(((Substitution)pair.getRight()).createImageOf(v.value));
                    CloseableIterator<Atom> match = data.match((Atom)pair.getLeft());
                    while (match.hasNext()) {
                        terms.add(match.next().getTerm(pos));
                    }
                }
            }
            if (this.getProfiler() != null) {
                this.getProfiler().stop("BootstrapTimeFirstPart");
            }
            if (terms == null) {
                void var11_19;
                double p;
                Object var11_16 = null;
                double probaA = 1.1;
                for (Atom atom : postAtoms) {
                    p = ProbaUtils.computeProba(atom, store, rc);
                    if (!(p < probaA)) continue;
                    Atom atom2 = atom;
                    p = probaA;
                }
                for (Atom atom : preAtoms) {
                    p = ProbaUtils.computeProba(atom, store, rc);
                    if (!(p < probaA)) continue;
                    Atom atom3 = atom;
                    p = probaA;
                }
                terms = BootstrapperUtils.computeCandidatesOverRewritings((Atom)var11_19, v, data, rc);
            }
            if (this.getProfiler() != null) {
                this.getProfiler().stop("BootstrapTime");
            }
            if (terms == null) {
                return data.termsIterator();
            }
            return new CloseableIteratorAdapter<Term>(terms.iterator());
        }
        catch (AtomSetException atomSetException) {
            throw new BacktrackException(atomSetException);
        }
        catch (IteratorException iteratorException) {
            throw new BacktrackException(iteratorException);
        }
    }

    static {
        fallback = StarBootstrapper.instance();
    }
}

