/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism.forward_checking;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.homomorphism.BacktrackException;
import fr.lirmm.graphik.integraal.homomorphism.Var;
import fr.lirmm.graphik.integraal.homomorphism.VarSharedData;
import fr.lirmm.graphik.integraal.homomorphism.forward_checking.AbstractNFC;
import fr.lirmm.graphik.integraal.homomorphism.forward_checking.ForwardChecking;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.Map;

public class NFC0
extends AbstractNFC
implements ForwardChecking {
    @Override
    public boolean checkForward(Var v, AtomSet g, Substitution initialSubstitution, Map<Variable, Integer> map, Var[] varData, RulesCompilation rc) throws BacktrackException {
        for (VarSharedData z : v.shared.postVars) {
            this.clear(v.shared, z);
        }
        for (Atom atom : v.shared.postAtoms) {
            if (!this.mustBeChecked(atom, map, varData)) continue;
            try {
                if (this.select(atom, v, g, initialSubstitution, map, varData, rc)) continue;
                return false;
            }
            catch (IteratorException e) {
                throw new BacktrackException("An error occurs while selecting candidates for next steps ", e);
            }
            catch (AtomSetException e) {
                throw new BacktrackException("An error occurs while selecting candidates for next steps ", e);
            }
        }
        return true;
    }

    protected boolean mustBeChecked(Atom atom, Map<Variable, Integer> map, Var[] varData) {
        int i = 0;
        for (Variable t : atom.getVariables()) {
            Integer idx = map.get(t);
            if (idx == null) continue;
            Var z = varData[idx];
            if (z.image == null || ++i <= 1) continue;
            return false;
        }
        return true;
    }
}

