/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism.scheduler;

import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.homomorphism.Var;
import fr.lirmm.graphik.integraal.homomorphism.VarSharedData;
import fr.lirmm.graphik.integraal.homomorphism.scheduler.AbstractScheduler;
import fr.lirmm.graphik.integraal.homomorphism.scheduler.Scheduler;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ComparableOrderScheduler
extends AbstractScheduler
implements Scheduler {
    private static ComparableOrderScheduler instance;

    private ComparableOrderScheduler() {
    }

    public static synchronized ComparableOrderScheduler instance() {
        if (instance == null) {
            instance = new ComparableOrderScheduler();
        }
        return instance;
    }

    @Override
    public VarSharedData[] execute(InMemoryAtomSet query, Set<Variable> preAffectedVars, List<Term> ans, AtomSet data, RulesCompilation rc) {
        InMemoryAtomSet h = preAffectedVars.isEmpty() ? query : ComparableOrderScheduler.computeFixedQuery(query, preAffectedVars);
        LinkedList<Variable> terms = new LinkedList<Variable>(h.getVariables());
        Collections.sort(terms);
        VarSharedData[] vars = new VarSharedData[terms.size() + 2];
        int level = 0;
        vars[level] = new VarSharedData(level);
        TreeSet<Term> alreadyAffected = new TreeSet<Term>();
        for (Term t : ans) {
            if (!terms.contains(t) || alreadyAffected.contains(t)) continue;
            vars[++level] = new VarSharedData(level);
            vars[level].value = (Variable)t;
            alreadyAffected.add(t);
        }
        int lastAnswerVariable = level;
        for (Term term : terms) {
            if (alreadyAffected.contains(term)) continue;
            vars[++level] = new VarSharedData(level);
            vars[level].value = (Variable)term;
        }
        vars[++level] = new VarSharedData(level);
        vars[level].previousLevel = lastAnswerVariable;
        return vars;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean isAllowed(Var var, Term image) {
        return true;
    }

    @Override
    public String getInfos(Var var) {
        return "";
    }
}

