/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser;

import fr.lirmm.graphik.integraal.rulesetanalyser.property.AGRDProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.BTSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.DisconnectedProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.DomainRestrictedProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.FESProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.FUSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.FrontierGuardedProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.FrontierOneProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.GBTSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.GuardedProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.JointlyFrontierGuardedSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.LinearProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.MFAProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.MSAProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.RangeRestrictedProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.RuleSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.StickyProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.WeaklyAcyclicProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.WeaklyFrontierGuardedSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.WeaklyGuardedSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.WeaklyStickyProperty;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.IterableUtils;

public class RuleSetPropertyHierarchy {
    private ArrayList<RuleSetProperty> properties;
    private Map<String, Integer> propertyIndex;
    private int currentPtyIndex;
    private boolean[][] specialisations;

    public RuleSetPropertyHierarchy() {
        this.setProperties(RuleSetPropertyHierarchy.generatePropertyMap().values());
    }

    public RuleSetPropertyHierarchy(Iterable<RuleSetProperty> pties) {
        this.setProperties(pties);
    }

    public void setProperties(Iterable<RuleSetProperty> pties) {
        this.properties = new ArrayList();
        this.propertyIndex = new TreeMap<String, Integer>();
        this.currentPtyIndex = 0;
        for (RuleSetProperty p : pties) {
            if (this.propertyIndex.get(p.getLabel()) != null) continue;
            this.propertyIndex.put(p.getLabel(), this.currentPtyIndex++);
            this.properties.add(p);
        }
        this.specialisations = new boolean[this.currentPtyIndex][this.currentPtyIndex];
        this.computeSpecialisations();
    }

    public Iterable<RuleSetProperty> getOrderedProperties() {
        int j;
        int i;
        LinkedList<RuleSetProperty> result = new LinkedList<RuleSetProperty>();
        boolean[][] spec = new boolean[this.currentPtyIndex][this.currentPtyIndex];
        boolean[] mark = new boolean[this.currentPtyIndex];
        for (i = 0; i < this.currentPtyIndex; ++i) {
            mark[i] = false;
            for (j = 0; j < this.currentPtyIndex; ++j) {
                spec[i][j] = this.specialisations[i][j];
            }
        }
        boolean running = true;
        while (running) {
            boolean is_source = false;
            for (i = 0; i < this.currentPtyIndex && !is_source; ++i) {
                if (mark[i]) continue;
                is_source = true;
                for (j = 0; j < this.currentPtyIndex && is_source; ++j) {
                    if (!spec[j][i]) continue;
                    is_source = false;
                }
            }
            --i;
            if (is_source) {
                mark[i] = true;
                result.add(this.properties.get(i));
                for (j = 0; j < this.currentPtyIndex; ++j) {
                    spec[i][j] = false;
                }
                continue;
            }
            running = false;
        }
        return result;
    }

    public Iterable<RuleSetProperty> getGeneralisationsOf(RuleSetProperty p) {
        LinkedList<RuleSetProperty> result = new LinkedList<RuleSetProperty>();
        int id = this.propertyIndex.get(p.getLabel());
        for (int j = 0; j < this.currentPtyIndex; ++j) {
            if (!this.specialisations[id][j]) continue;
            result.add(this.properties.get(j));
        }
        return result;
    }

    private void computeSpecialisations() {
        for (int i = 0; i < this.currentPtyIndex; ++i) {
            for (int j = 0; j < this.currentPtyIndex; ++j) {
                this.specialisations[i][j] = false;
            }
        }
        for (RuleSetProperty p : this.properties) {
            int id1;
            int id0 = this.propertyIndex.get(p.getLabel());
            for (RuleSetProperty p2 : p.getGeneralisations()) {
                if (this.propertyIndex.get(p2.getLabel()) == null) continue;
                id1 = this.propertyIndex.get(p2.getLabel());
                this.specialisations[id0][id1] = true;
            }
            for (RuleSetProperty p2 : p.getSpecialisations()) {
                if (this.propertyIndex.get(p2.getLabel()) == null) continue;
                id1 = this.propertyIndex.get(p2.getLabel());
                this.specialisations[id1][id0] = true;
            }
        }
        this.computeSpecialisationClosure();
    }

    private void computeSpecialisationClosure() {
        while (this.computeSpecialisationClosureStep()) {
        }
    }

    private boolean computeSpecialisationClosureStep() {
        boolean mod = false;
        for (int i = 0; i < this.currentPtyIndex; ++i) {
            for (int j = 0; j < this.currentPtyIndex; ++j) {
                if (!this.specialisations[i][j]) continue;
                for (int k = 0; k < this.currentPtyIndex; ++k) {
                    if (!this.specialisations[j][k]) continue;
                    if (!this.specialisations[i][k]) {
                        mod = true;
                    }
                    this.specialisations[i][k] = true;
                }
            }
        }
        return mod;
    }

    public static final Map<String, RuleSetProperty> generatePropertyMap() {
        TreeMap<String, RuleSetProperty> propertyMap = new TreeMap<String, RuleSetProperty>();
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, AGRDProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, BTSProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, DisconnectedProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, DomainRestrictedProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, FESProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, FrontierGuardedProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, FrontierOneProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, FUSProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, GuardedProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, GBTSProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, JointlyFrontierGuardedSetProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, LinearProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, MFAProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, MSAProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, RangeRestrictedProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, StickyProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, WeaklyAcyclicProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, WeaklyFrontierGuardedSetProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, WeaklyGuardedSetProperty.instance());
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, WeaklyStickyProperty.instance());
        return propertyMap;
    }

    public static final Map<String, RuleSetProperty> generatePropertyMapSpecializationOf(RuleSetProperty prop) {
        TreeMap<String, RuleSetProperty> propertyMap = new TreeMap<String, RuleSetProperty>();
        RuleSetPropertyHierarchy.addToPropertyMap(propertyMap, prop);
        for (Map.Entry<String, RuleSetProperty> e : RuleSetPropertyHierarchy.generatePropertyMap().entrySet()) {
            if (!IterableUtils.contains(e.getValue().getGeneralisations(), (Object)prop)) continue;
            propertyMap.put(e.getKey(), e.getValue());
        }
        return propertyMap;
    }

    private static final void addToPropertyMap(Map<String, RuleSetProperty> map, RuleSetProperty p) {
        map.put(p.getLabel(), p);
    }
}

