/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser.graph;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.rulesetanalyser.util.PredicatePosition;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.GabowStrongConnectivityInspector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class GraphPositionDependencies {
    private Set<PredicatePosition> isFiniteRank = null;
    private Graph<PredicatePosition, DefaultEdge> graph = new DefaultDirectedGraph(DefaultEdge.class);
    private Iterable<Rule> rules;

    public GraphPositionDependencies(Iterable<Rule> rules) {
        this.rules = rules;
        this.init();
    }

    public Set<DefaultEdge> edgeSet() {
        return this.graph.edgeSet();
    }

    public PredicatePosition getEdgeTarget(DefaultEdge e) {
        return (PredicatePosition)this.graph.getEdgeTarget((Object)e);
    }

    public PredicatePosition getEdgeSource(DefaultEdge e) {
        return (PredicatePosition)this.graph.getEdgeSource((Object)e);
    }

    public boolean isWeaklyAcyclic() {
        for (DefaultEdge e : this.graph.edgeSet()) {
            if (!(e instanceof SpecialEdge)) continue;
            PredicatePosition head = (PredicatePosition)this.graph.getEdgeTarget((Object)e);
            PredicatePosition tail = (PredicatePosition)this.graph.getEdgeSource((Object)e);
            TreeSet<PredicatePosition> markedVertex = new TreeSet<PredicatePosition>();
            markedVertex.add(head);
            markedVertex.add(tail);
            if (!this.findSpecialCycle(head, markedVertex, tail)) continue;
            return false;
        }
        return true;
    }

    public boolean isFiniteRank(Predicate p, int position) {
        return this.isFiniteRank(new PredicatePosition(p, position));
    }

    public void initFiniteRank() {
        if (this.isFiniteRank == null) {
            this.isFiniteRank = new TreeSet<PredicatePosition>();
            GabowStrongConnectivityInspector sccInspector = new GabowStrongConnectivityInspector(this.graph);
            List sccList = sccInspector.stronglyConnectedSets();
            for (Set scc : sccList) {
                boolean componentIsFiniteRank = true;
                for (PredicatePosition p1 : scc) {
                    for (PredicatePosition p2 : scc) {
                        for (DefaultEdge edge : this.graph.getAllEdges((Object)p1, (Object)p2)) {
                            if (!(edge instanceof SpecialEdge)) continue;
                            componentIsFiniteRank = false;
                        }
                    }
                }
                if (!componentIsFiniteRank) continue;
                for (PredicatePosition p : scc) {
                    this.isFiniteRank.add(p);
                }
            }
        }
    }

    public boolean isFiniteRank(PredicatePosition p) {
        this.initFiniteRank();
        return this.isFiniteRank.contains(p);
    }

    private boolean findSpecialCycle(PredicatePosition vertex, Set<PredicatePosition> markedVertex, PredicatePosition vertexCible) {
        for (DefaultEdge edge : this.graph.outgoingEdgesOf((Object)vertex)) {
            PredicatePosition v = (PredicatePosition)this.graph.getEdgeTarget((Object)edge);
            if (v.equals(vertexCible)) {
                return true;
            }
            if (markedVertex.contains(v)) continue;
            markedVertex.add(v);
            if (!this.findSpecialCycle(v, markedVertex, vertexCible)) continue;
            return true;
        }
        return false;
    }

    private void init() {
        for (Rule r : this.rules) {
            Set<Variable> existentials = r.getExistentials();
            for (Atom bodyAtom : r.getBody()) {
                int bodyTermIndex = -1;
                for (Term bodyTerm : bodyAtom) {
                    ++bodyTermIndex;
                    if (r.getHead().getTerms().contains(bodyTerm)) {
                        for (Atom headAtom : r.getHead()) {
                            int headTermIndex = -1;
                            for (Term headTerm : headAtom) {
                                ++headTermIndex;
                                if (bodyTerm.equals(headTerm)) {
                                    this.addEdge(new PredicatePosition(bodyAtom.getPredicate(), bodyTermIndex), new PredicatePosition(headAtom.getPredicate(), headTermIndex));
                                    continue;
                                }
                                if (!existentials.contains(headTerm)) continue;
                                this.addSpecialEdge(new PredicatePosition(bodyAtom.getPredicate(), bodyTermIndex), new PredicatePosition(headAtom.getPredicate(), headTermIndex));
                            }
                        }
                        continue;
                    }
                    if (this.graph.containsVertex((Object)new PredicatePosition(bodyAtom.getPredicate(), bodyTermIndex))) continue;
                    this.graph.addVertex((Object)new PredicatePosition(bodyAtom.getPredicate(), bodyTermIndex));
                }
            }
        }
    }

    private void addSpecialEdge(PredicatePosition predicatePosition, PredicatePosition predicatePosition2) {
        if (this.graph.containsEdge((Object)predicatePosition, (Object)predicatePosition2)) {
            this.graph.removeEdge((Object)predicatePosition, (Object)predicatePosition2);
        } else {
            if (!this.graph.containsVertex((Object)predicatePosition)) {
                this.graph.addVertex((Object)predicatePosition);
            }
            if (!this.graph.containsVertex((Object)predicatePosition2)) {
                this.graph.addVertex((Object)predicatePosition2);
            }
        }
        this.graph.addEdge((Object)predicatePosition, (Object)predicatePosition2, (Object)new SpecialEdge());
    }

    private void addEdge(PredicatePosition predicatePosition, PredicatePosition predicatePosition2) {
        if (!this.graph.containsEdge((Object)predicatePosition, (Object)predicatePosition2)) {
            if (!this.graph.containsVertex((Object)predicatePosition)) {
                this.graph.addVertex((Object)predicatePosition);
            }
            if (!this.graph.containsVertex((Object)predicatePosition2)) {
                this.graph.addVertex((Object)predicatePosition2);
            }
            this.graph.addEdge((Object)predicatePosition, (Object)predicatePosition2);
        }
    }

    public static class SpecialEdge
    extends DefaultEdge {
        private static final long serialVersionUID = 3660050932528046714L;
    }
}

