/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser.graph;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.rulesetanalyser.graph.AbstractAffectedPositionSet;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import java.util.Iterator;

public class JointlyAffectedPositionSet
extends AbstractAffectedPositionSet {
    public JointlyAffectedPositionSet(Iterable<Rule> ruleSet) {
        super(ruleSet);
    }

    @Override
    protected void step2() {
        boolean fixPoint = false;
        while (!fixPoint) {
            fixPoint = true;
            for (Rule rule : this.ruleSet) {
                InMemoryAtomSet body = rule.getBody();
                for (Variable term : rule.getBody().getVariables()) {
                    boolean isAffected = true;
                    CloseableIterator atomIt = body.iterator();
                    while (atomIt.hasNext() && isAffected) {
                        int i = -1;
                        Atom a = (Atom)atomIt.next();
                        Iterator<Term> termIt = a.iterator();
                        while (termIt.hasNext() && isAffected) {
                            Term t = termIt.next();
                            if (!term.equals(t) || this.isAffected(a.getPredicate(), ++i)) continue;
                            isAffected = false;
                        }
                    }
                    if (!isAffected || !this.affectInHead(rule, term)) continue;
                    fixPoint = false;
                }
            }
        }
    }
}

