/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser.property;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.BTSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.FrontierGuardedProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.GBTSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.JointlyFrontierGuardedSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.RuleSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.WeaklyFrontierGuardedSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.WeaklyGuardedSetProperty;
import java.util.LinkedList;
import java.util.Set;

public final class GuardedProperty
extends RuleSetProperty.Local {
    private static GuardedProperty instance = null;

    private GuardedProperty() {
    }

    public static synchronized GuardedProperty instance() {
        if (instance == null) {
            instance = new GuardedProperty();
        }
        return instance;
    }

    @Override
    public String getFullName() {
        return "Guarded";
    }

    @Override
    public String getDescription() {
        return "At least one atom in the body (called a guard) contains all the variables from the body.";
    }

    @Override
    public int check(Rule rule) {
        Set<Variable> bodyVars = rule.getBody().getVariables();
        boolean isGuarded = true;
        for (Atom a : rule.getBody()) {
            isGuarded = true;
            for (Term term : bodyVars) {
                if (a.getTerms().contains(term)) continue;
                isGuarded = false;
                break;
            }
            if (!isGuarded) continue;
            break;
        }
        if (isGuarded) {
            return 1;
        }
        return -1;
    }

    @Override
    public String getLabel() {
        return "g";
    }

    @Override
    public Iterable<RuleSetProperty> getGeneralisations() {
        LinkedList<RuleSetProperty> gen = new LinkedList<RuleSetProperty>();
        gen.add(FrontierGuardedProperty.instance());
        gen.add(WeaklyGuardedSetProperty.instance());
        gen.add(WeaklyFrontierGuardedSetProperty.instance());
        gen.add(JointlyFrontierGuardedSetProperty.instance());
        gen.add(GBTSProperty.instance());
        gen.add(BTSProperty.instance());
        return gen;
    }
}

