/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser.property;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.rulesetanalyser.graph.MarkedVariableSet;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.FUSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.RuleSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.util.AnalyserRuleSet;
import java.util.LinkedList;

public final class StickyProperty
extends RuleSetProperty.Default {
    private static StickyProperty instance = null;

    private StickyProperty() {
    }

    public static synchronized StickyProperty instance() {
        if (instance == null) {
            instance = new StickyProperty();
        }
        return instance;
    }

    @Override
    public String getFullName() {
        return "Sticky";
    }

    @Override
    public String getDescription() {
        return "Each marked variable occurs at most once in a rule body (cf. marked variable set).";
    }

    @Override
    public int check(AnalyserRuleSet ruleSet) {
        if (this.check(ruleSet.getMarkedVariableSet())) {
            return 1;
        }
        return -1;
    }

    public boolean check(MarkedVariableSet markedVariableSet) {
        for (MarkedVariableSet.MarkedRule mrule : markedVariableSet.getMarkedRuleCollection()) {
            for (Term mvar : mrule.markedVars) {
                int nbOccurence = 0;
                for (Atom a : mrule.rule.getBody()) {
                    for (Term t : a) {
                        if (!mvar.equals(t) || ++nbOccurence <= 1) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public String getLabel() {
        return "s";
    }

    @Override
    public Iterable<RuleSetProperty> getGeneralisations() {
        LinkedList<RuleSetProperty> gen = new LinkedList<RuleSetProperty>();
        gen.add(FUSProperty.instance());
        return gen;
    }
}

