/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser.property;

import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.core.Rules;
import fr.lirmm.graphik.integraal.rulesetanalyser.graph.AffectedPositionSet;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.BTSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.GBTSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.JointlyFrontierGuardedSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.RuleSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.util.AnalyserRuleSet;
import java.util.LinkedList;
import java.util.Set;

public final class WeaklyFrontierGuardedSetProperty
extends RuleSetProperty.Default {
    private static WeaklyFrontierGuardedSetProperty instance = null;

    private WeaklyFrontierGuardedSetProperty() {
    }

    public static synchronized WeaklyFrontierGuardedSetProperty instance() {
        if (instance == null) {
            instance = new WeaklyFrontierGuardedSetProperty();
        }
        return instance;
    }

    @Override
    public String getFullName() {
        return "Weakly frontier guarded";
    }

    @Override
    public String getDescription() {
        return "At least one atom in the body of each rule contains all affected variable from the frontier (cf. affected position set).";
    }

    @Override
    public int check(AnalyserRuleSet ruleSet) {
        if (this.check(ruleSet.getAffectedPositionSet())) {
            return 1;
        }
        return -1;
    }

    @Override
    public String getLabel() {
        return "wfg";
    }

    private boolean check(AffectedPositionSet affectedPositionSet) {
        for (Rule r : affectedPositionSet.getRules()) {
            Set affectedVars = affectedPositionSet.getAllAffectedFrontierVariables(r);
            if (Rules.isThereOneAtomThatContainsAllVars(r.getBody(), affectedVars)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterable<RuleSetProperty> getGeneralisations() {
        LinkedList<RuleSetProperty> gen = new LinkedList<RuleSetProperty>();
        gen.add(JointlyFrontierGuardedSetProperty.instance());
        gen.add(GBTSProperty.instance());
        gen.add(BTSProperty.instance());
        return gen;
    }
}

