/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser.util;

import fr.lirmm.graphik.integraal.api.core.ImmutableRuleSet;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.RuleLabeler;
import fr.lirmm.graphik.integraal.api.core.RuleSet;
import fr.lirmm.graphik.integraal.api.core.RuleSetException;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.unifier.DependencyChecker;
import fr.lirmm.graphik.integraal.core.DefaultRuleLabeler;
import fr.lirmm.graphik.integraal.core.compilation.NoCompilation;
import fr.lirmm.graphik.integraal.core.grd.DefaultGraphOfRuleDependencies;
import fr.lirmm.graphik.integraal.core.ruleset.LinkedListRuleSet;
import fr.lirmm.graphik.integraal.core.unifier.checker.AtomErasingChecker;
import fr.lirmm.graphik.integraal.core.unifier.checker.ProductivityChecker;
import fr.lirmm.graphik.integraal.rulesetanalyser.graph.AffectedPositionSet;
import fr.lirmm.graphik.integraal.rulesetanalyser.graph.GraphPositionDependencies;
import fr.lirmm.graphik.integraal.rulesetanalyser.graph.JointlyAffectedPositionSet;
import fr.lirmm.graphik.integraal.rulesetanalyser.graph.MarkedVariableSet;
import fr.lirmm.graphik.util.graph.scc.StronglyConnectedComponentsGraph;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AnalyserRuleSet
implements ImmutableRuleSet {
    private Collection<Rule> ruleset;
    private DefaultGraphOfRuleDependencies grd;
    private AffectedPositionSet affectedPositionSet;
    private JointlyAffectedPositionSet jointlyAffectedPositionSet;
    private GraphPositionDependencies graphPositionDependencies;
    private MarkedVariableSet markedVariableSet;
    private StronglyConnectedComponentsGraph<Rule> sccGraph;
    private List<AnalyserRuleSet> scc;
    private List<DependencyChecker> dependencyCheckerList;
    private boolean withUnifiers = false;
    private RuleLabeler labeler = new DefaultRuleLabeler();
    private RulesCompilation compilation = NoCompilation.instance();

    public AnalyserRuleSet(Rule rule) {
        LinkedListRuleSet list = new LinkedListRuleSet();
        list.add(rule);
        this.ruleset = Collections.unmodifiableCollection(list);
        this.dependencyCheckerList = new LinkedList<DependencyChecker>();
        this.dependencyCheckerList.add(ProductivityChecker.instance());
        this.dependencyCheckerList.add(AtomErasingChecker.instance());
    }

    public AnalyserRuleSet(Iterable<Rule> rules) {
        this(rules.iterator());
    }

    public AnalyserRuleSet(Iterable<Rule> rules, DependencyChecker checker) {
        this(rules.iterator(), checker);
    }

    public AnalyserRuleSet(Iterator<Rule> rules) {
        this.ruleset = Collections.unmodifiableCollection(new LinkedListRuleSet(rules));
        this.setRuleLabels();
        this.dependencyCheckerList = new LinkedList<DependencyChecker>();
        this.dependencyCheckerList.add(ProductivityChecker.instance());
        this.dependencyCheckerList.add(AtomErasingChecker.instance());
    }

    public AnalyserRuleSet(Iterator<Rule> rules, DependencyChecker ... checkers) {
        this.ruleset = Collections.unmodifiableCollection(new LinkedListRuleSet(rules));
        this.setRuleLabels();
        this.dependencyCheckerList = Arrays.asList(checkers);
    }

    public AnalyserRuleSet(Iterator<Rule> rules, RulesCompilation compilation) {
        this(rules);
        this.compilation = compilation;
    }

    public AnalyserRuleSet(CloseableIterator<Rule> rules) throws RuleSetException {
        this.ruleset = Collections.unmodifiableCollection(new LinkedListRuleSet(rules));
        this.setRuleLabels();
        this.dependencyCheckerList = new LinkedList<DependencyChecker>();
        this.dependencyCheckerList.add(ProductivityChecker.instance());
        this.dependencyCheckerList.add(AtomErasingChecker.instance());
    }

    public AnalyserRuleSet(CloseableIterator<Rule> rules, DependencyChecker ... checkers) throws RuleSetException {
        this.ruleset = Collections.unmodifiableCollection(new LinkedListRuleSet(rules));
        this.setRuleLabels();
        this.dependencyCheckerList = Arrays.asList(checkers);
    }

    public AnalyserRuleSet(DefaultGraphOfRuleDependencies grd) {
        LinkedList<Rule> c = new LinkedList<Rule>();
        for (Rule r : grd.getRules()) {
            this.labeler.setLabel(r);
            c.add(r);
        }
        this.ruleset = Collections.unmodifiableCollection(c);
        this.grd = grd;
    }

    private final void setRuleLabels() {
        for (Rule r : this.ruleset) {
            this.labeler.setLabel(r);
        }
    }

    public void addDependencyChecker(DependencyChecker checker) {
        this.dependencyCheckerList.add(checker);
    }

    public void removeDependencyChecker(DependencyChecker checker) {
        this.dependencyCheckerList.remove(checker);
    }

    public void clearDependencyChecker() {
        this.dependencyCheckerList.clear();
    }

    public void enableUnifiers(boolean wu) {
        this.withUnifiers = wu;
    }

    public DefaultGraphOfRuleDependencies getGraphOfRuleDependencies() {
        if (this.grd == null) {
            this.computeGRD();
        }
        return this.grd;
    }

    public void setGraphOfRuleDependencies(DefaultGraphOfRuleDependencies grd) {
        this.grd = grd;
        this.sccGraph = null;
    }

    public AffectedPositionSet getAffectedPositionSet() {
        if (this.affectedPositionSet == null) {
            this.computeAffectedPositionSet();
        }
        return this.affectedPositionSet;
    }

    public JointlyAffectedPositionSet getJointlyAffectedPositionSet() {
        if (this.jointlyAffectedPositionSet == null) {
            this.computeJointlyAffectedPositionSet();
        }
        return this.jointlyAffectedPositionSet;
    }

    public GraphPositionDependencies getGraphPositionDependencies() {
        if (this.graphPositionDependencies == null) {
            this.computeGraphPositionDependencies();
        }
        return this.graphPositionDependencies;
    }

    public MarkedVariableSet getMarkedVariableSet() {
        if (this.markedVariableSet == null) {
            this.computeMarkedVariableSet();
        }
        return this.markedVariableSet;
    }

    public StronglyConnectedComponentsGraph<Rule> getStronglyConnectedComponentsGraph() {
        if (this.sccGraph == null) {
            this.sccGraph = this.getGraphOfRuleDependencies().getStronglyConnectedComponentsGraph();
        }
        return this.sccGraph;
    }

    public AnalyserRuleSet getSubRuleSetAnalyser(Iterable<Rule> rules) {
        return new AnalyserRuleSet((DefaultGraphOfRuleDependencies)this.getGraphOfRuleDependencies().getSubGraph((Iterable)rules));
    }

    public List<AnalyserRuleSet> getSCC() {
        if (this.scc == null) {
            this.computeSCC();
        }
        return this.scc;
    }

    @Override
    public boolean contains(Rule rule) {
        return this.ruleset.contains(rule);
    }

    @Override
    public Iterator<Rule> iterator() {
        return this.ruleset.iterator();
    }

    private void computeGRD() {
        this.grd = new DefaultGraphOfRuleDependencies((RuleSet)new LinkedListRuleSet(this.ruleset), this.compilation, this.withUnifiers, this.dependencyCheckerList.toArray(new DependencyChecker[0]));
    }

    private void computeSCC() {
        this.scc = new LinkedList<AnalyserRuleSet>();
        Iterator iterator = this.getStronglyConnectedComponentsGraph().vertexSet().iterator();
        while (iterator.hasNext()) {
            int s = (Integer)iterator.next();
            this.scc.add(this.getSubRuleSetAnalyser(this.getStronglyConnectedComponentsGraph().getComponent(s)));
        }
    }

    private void computeAffectedPositionSet() {
        this.affectedPositionSet = new AffectedPositionSet(this);
    }

    private void computeJointlyAffectedPositionSet() {
        this.jointlyAffectedPositionSet = new JointlyAffectedPositionSet(this);
    }

    private void computeGraphPositionDependencies() {
        this.graphPositionDependencies = new GraphPositionDependencies(this);
    }

    private void computeMarkedVariableSet() {
        this.markedVariableSet = new MarkedVariableSet(this);
    }

    @Override
    public int size() {
        return this.ruleset.size();
    }

    @Override
    public boolean isEmpty() {
        return this.ruleset.isEmpty();
    }
}

