/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class Apps {
    private Apps() {
    }

    public static void printVersion(String applicationName) {
        String buildDate;
        String vendor;
        String version;
        try {
            URL pathToManifest = new URL(Apps.getPathToManifest());
            InputStream is = pathToManifest.openStream();
            Manifest manifest = new Manifest(is);
            Attributes att = manifest.getMainAttributes();
            version = att.getValue("Specification-Version");
            vendor = att.getValue("Specification-Vendor");
            buildDate = att.getValue("Built-On");
            is.close();
        }
        catch (IOException ex) {
            buildDate = "?";
            vendor = "?";
            version = "?";
        }
        System.out.print(applicationName);
        System.out.print(" version \"");
        System.out.print(version);
        System.out.println("\"");
        System.out.print("Built on ");
        System.out.println(buildDate);
        System.out.print("Produced by ");
        System.out.println(vendor);
    }

    private static String getPathToManifest() {
        String classSimpleName = Apps.class.getSimpleName() + ".class";
        String pathToClass = Apps.class.getResource(classSimpleName).toString();
        String classFullName = Apps.class.getName().replace('.', '/') + ".class";
        String pathToManifest = pathToClass.substring(0, pathToClass.length() - classFullName.length()) + "META-INF/MANIFEST.MF";
        return pathToManifest;
    }
}

