/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util;

public enum TimeUnit {
    HOURS(java.util.concurrent.TimeUnit.HOURS, "h"),
    MINUTES(java.util.concurrent.TimeUnit.MINUTES, "min"),
    SECONDS(java.util.concurrent.TimeUnit.SECONDS, "s"),
    MILLISECONDS(java.util.concurrent.TimeUnit.MILLISECONDS, "ms"),
    MICROSECONDS(java.util.concurrent.TimeUnit.MICROSECONDS, "\u03bcs"),
    NANOSECONDS(java.util.concurrent.TimeUnit.NANOSECONDS, "ns");

    private java.util.concurrent.TimeUnit encapsuled;
    private String abbrev;

    private TimeUnit(java.util.concurrent.TimeUnit encapsuled, String abbrev) {
        this.encapsuled = encapsuled;
        this.abbrev = abbrev;
    }

    public String getAbbreviation() {
        return this.abbrev;
    }

    public long convert(long sourceDuration, TimeUnit sourceUnit) {
        return this.encapsuled.convert(sourceDuration, sourceUnit.encapsuled);
    }

    public long round(long sourceDuration, TimeUnit timeUnit) {
        long i = timeUnit.convert(1L, this);
        if (i == 0L) {
            return this.convert(sourceDuration, timeUnit);
        }
        return (sourceDuration + i / 2L) / i;
    }

    public long toHours(long duration) {
        return HOURS.convert(duration, this);
    }

    public long toMicros(long duration) {
        return MICROSECONDS.convert(duration, this);
    }

    public long toMillis(long duration) {
        return MILLISECONDS.convert(duration, this);
    }

    public long toMinutes(long duration) {
        return MINUTES.convert(duration, this);
    }

    public long toNanos(long duration) {
        return NANOSECONDS.convert(duration, this);
    }

    public long toSeconds(long duration) {
        return SECONDS.convert(duration, this);
    }

    public long roundToHours(long duration) {
        return HOURS.round(duration, this);
    }

    public long roundToMicros(long duration) {
        return MICROSECONDS.round(duration, this);
    }

    public long roundToMillis(long duration) {
        return MILLISECONDS.round(duration, this);
    }

    public long roundToMinutes(long duration) {
        return MINUTES.round(duration, this);
    }

    public long roundToNanos(long duration) {
        return NANOSECONDS.round(duration, this);
    }

    public long roundToSeconds(long duration) {
        return SECONDS.round(duration, this);
    }

    public String toString() {
        return this.encapsuled.toString();
    }
}

