/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util;

import fr.lirmm.graphik.util.EquivalentRelation;
import java.util.Map;
import java.util.TreeMap;

public class TreeMapEquivalentRelation<T extends Comparable<T>>
implements EquivalentRelation<T> {
    private Integer maxClassesValue = 0;
    private final TreeMap<T, Integer> classes = new TreeMap();

    @Override
    public int addClasse(Iterable<T> elements) {
        Integer classe = this.maxClassesValue = Integer.valueOf(this.maxClassesValue + 1);
        for (Comparable e : elements) {
            this.classes.put(e, classe);
        }
        return classe;
    }

    @Override
    @SafeVarargs
    public final int addClasse(T ... elements) {
        Integer classe = this.maxClassesValue = Integer.valueOf(this.maxClassesValue + 1);
        for (T e : elements) {
            this.classes.put(e, classe);
        }
        return classe;
    }

    @Override
    public void mergeClasses(T o1, T o2) {
        Integer c1 = this.classes.get(o1);
        Integer c2 = this.classes.get(o2);
        if (c1 == null && c2 == null) {
            this.addClasse(new Comparable[]{o1, o2});
        } else if (c1 == null) {
            this.classes.put(o1, c2);
        } else if (c2 == null) {
            this.classes.put(o2, c1);
        } else {
            for (Map.Entry<T, Integer> e : this.classes.entrySet()) {
                if (!e.getValue().equals(c1)) continue;
                this.classes.put((Comparable)e.getKey(), c2);
            }
        }
    }

    @Override
    public boolean compare(T o1, T o2) {
        boolean res;
        boolean bl = res = o1 == o2;
        if (!res) {
            Integer c1 = this.classes.get(o1);
            Integer c2 = this.classes.get(o2);
            if (c1 != null && c2 != null) {
                res = c1.equals(c2);
            }
        }
        return res;
    }

    @Override
    public int getIdClass(T o) {
        Integer id = this.classes.get(o);
        if (id == null) {
            id = this.addClasse(new Comparable[]{o});
        }
        return id;
    }
}

