/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util;

import fr.lirmm.graphik.util.DefaultURI;
import fr.lirmm.graphik.util.Prefix;
import fr.lirmm.graphik.util.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

public final class URIUtils {
    public static final URI RDF_TYPE = URIUtils.createURI(Prefix.RDF, "type");
    public static final URI RDF_LANG_STRING = URIUtils.createURI(Prefix.RDF, "langString");
    public static final URI XSD_STRING = URIUtils.createURI(Prefix.XSD, "string");
    public static final URI XSD_BOOLEAN = URIUtils.createURI(Prefix.XSD, "boolean");
    public static final URI XSD_DECIMAL = URIUtils.createURI(Prefix.XSD, "decimal");
    public static final URI XSD_FLOAT = URIUtils.createURI(Prefix.XSD, "float");
    public static final URI XSD_DOUBLE = URIUtils.createURI(Prefix.XSD, "double");
    public static final URI XSD_DURATION = URIUtils.createURI(Prefix.XSD, "duration");
    public static final URI XSD_DATE_TIME = URIUtils.createURI(Prefix.XSD, "dateTime");
    public static final URI XSD_TIME = URIUtils.createURI(Prefix.XSD, "time");
    public static final URI XSD_DATE = URIUtils.createURI(Prefix.XSD, "date");
    public static final URI XSD_G_YEAR_MONTH = URIUtils.createURI(Prefix.XSD, "gYearMonth");
    public static final URI XSD_G_YEAR = URIUtils.createURI(Prefix.XSD, "gYear");
    public static final URI XSD_G_MONTH_DAY = URIUtils.createURI(Prefix.XSD, "gMonthDay");
    public static final URI XSD_G_DAY = URIUtils.createURI(Prefix.XSD, "gDay");
    public static final URI XSD_G_MONTH = URIUtils.createURI(Prefix.XSD, "gMonth");
    public static final URI XSD_HEX_BINARY = URIUtils.createURI(Prefix.XSD, "hexBinary");
    public static final URI XSD_BASE64_BINARY = URIUtils.createURI(Prefix.XSD, "base64Binary");
    public static final URI XSD_ANY_URI = URIUtils.createURI(Prefix.XSD, "anyURI");
    public static final URI XSD_Q_NAME = URIUtils.createURI(Prefix.XSD, "QName");
    public static final URI XSD_NOTATION = URIUtils.createURI(Prefix.XSD, "NOTATION");
    public static final URI XSD_INTEGER = URIUtils.createURI(Prefix.XSD, "integer");
    public static final Pattern LITERAL_PATTERN = Pattern.compile("\"(.*)\"\\^\\^<(.*)>");

    private URIUtils() {
    }

    public static boolean isValidURI(String uriRef) {
        boolean isValid = !uriRef.matches("[\u0000-\u001f\u007f-\u009f]");
        try {
            java.net.URI uri = new java.net.URI(uriRef);
            isValid = uri.isAbsolute();
        }
        catch (URISyntaxException e) {
            isValid = false;
        }
        return isValid;
    }

    public static String getScheme(String uri) {
        java.net.URI tmp;
        try {
            tmp = new java.net.URI(uri);
        }
        catch (URISyntaxException e) {
            return "";
        }
        return tmp.getScheme();
    }

    public static String getLocalName(String uri) {
        try {
            int localNameIdx = URIUtils.getLocalNameIndex(uri);
            return uri.substring(localNameIdx);
        }
        catch (IllegalArgumentException e) {
            return uri;
        }
    }

    public static String getPrefix(String uri) {
        try {
            int localNameIdx = URIUtils.getLocalNameIndex(uri);
            return uri.substring(0, localNameIdx);
        }
        catch (IllegalArgumentException e) {
            return "";
        }
    }

    public static URI createURI(String string, Prefix defaultPrefix) {
        String prefixString = URIUtils.getPrefix(string);
        if (prefixString.isEmpty()) {
            prefixString = defaultPrefix.getPrefix();
        }
        String localname = URIUtils.getLocalName(string);
        return new DefaultURI(prefixString, localname);
    }

    public static URI createURI(Prefix prefix, String localname) {
        return new DefaultURI(prefix.getPrefix(), localname);
    }

    public static URI createURI(String uri) {
        return new DefaultURI(uri);
    }

    public static int getLocalNameIndex(String uri) {
        int separatorIdx = uri.indexOf(35);
        int tmp = uri.lastIndexOf(47);
        if (tmp > separatorIdx) {
            separatorIdx = tmp;
        }
        if ((tmp = uri.lastIndexOf(58)) > separatorIdx) {
            separatorIdx = tmp;
        }
        if (separatorIdx < 0) {
            throw new IllegalArgumentException("No separator character founds in URI: " + uri);
        }
        return separatorIdx + 1;
    }
}

