/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.graph;

import fr.lirmm.graphik.util.graph.DirectedEdge;
import fr.lirmm.graphik.util.graph.DirectedGraph;
import java.util.Iterator;
import java.util.LinkedList;

public class DefaultDirectedGraph
implements DirectedGraph {
    private LinkedList<Integer>[] adjacencyList;
    private int nbVertices;

    public DefaultDirectedGraph(int nbVertices) {
        this.nbVertices = nbVertices;
        this.adjacencyList = new LinkedList[nbVertices];
        for (int i = 0; i < nbVertices; ++i) {
            this.adjacencyList[i] = new LinkedList();
        }
    }

    @Override
    public int nbVertices() {
        return this.nbVertices;
    }

    @Override
    public Iterator<Integer> adjacencyList(int v) {
        return this.adjacencyList[v].iterator();
    }

    @Override
    public void add(DirectedEdge e) {
        this.addEdge(e.getTail(), e.getHead());
    }

    @Override
    public void addEdge(int tail, int head) {
        this.adjacencyList[tail].add(head);
    }
}

