/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.graph;

import fr.lirmm.graphik.util.graph.Edge;
import fr.lirmm.graphik.util.graph.Graph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class DefaultGraph
implements Graph {
    private ArrayList<LinkedList<Integer>> adjacencyList;
    private int nbVertices;

    public DefaultGraph() {
        this(0);
    }

    public DefaultGraph(int nbVertices) {
        this.nbVertices = nbVertices;
        this.adjacencyList = new ArrayList();
        for (int i = 0; i < nbVertices; ++i) {
            this.adjacencyList.add(new LinkedList());
        }
    }

    @Override
    public int nbVertices() {
        return this.nbVertices;
    }

    @Override
    public int addVertex() {
        this.adjacencyList.add(new LinkedList());
        return this.nbVertices++;
    }

    @Override
    public Iterator<Integer> adjacencyList(int v) {
        return this.adjacencyList.get(v).iterator();
    }

    @Override
    public void add(Edge e) {
        this.addEdge(e.getFirst(), e.getSecond());
    }

    @Override
    public void addEdge(int v1, int v2) {
        this.adjacencyList.get(v1).add(v2);
        this.adjacencyList.get(v2).add(v1);
    }

    @Override
    public void addPath(int ... path) {
        for (int i = 1; i < path.length; ++i) {
            this.addEdge(path[i - 1], path[i]);
        }
    }
}

