/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.graph.scc;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.GabowStrongConnectivityInspector;
import org.jgrapht.graph.DefaultDirectedGraph;

public class StronglyConnectedComponentsGraph<V>
extends DefaultDirectedGraph<Integer, Integer> {
    private static final long serialVersionUID = -2816870306827502776L;
    private int edgeMaxIndex = -1;
    private final Map<Integer, Set<V>> map = new TreeMap<Integer, Set<V>>();

    public StronglyConnectedComponentsGraph() {
        super(Integer.class);
    }

    public <E> StronglyConnectedComponentsGraph(Graph<V, E> graph) {
        this();
        List stronglyConnectedSets = new GabowStrongConnectivityInspector(graph).stronglyConnectedSets();
        int componentIndex = -1;
        for (Set component : stronglyConnectedSets) {
            this.addComponent(++componentIndex, component);
        }
        Iterator iterator = this.vertexSet().iterator();
        while (iterator.hasNext()) {
            int src = (Integer)iterator.next();
            Iterator iterator2 = this.vertexSet().iterator();
            block2: while (iterator2.hasNext()) {
                int target = (Integer)iterator2.next();
                if (src == target) continue;
                for (V s : this.getComponent(src)) {
                    for (V t : this.getComponent(target)) {
                        if (graph.getEdge(s, t) == null) continue;
                        this.addEdge(src, target);
                        break;
                    }
                    if (this.getEdge(src, target) == null) continue;
                    continue block2;
                }
            }
        }
    }

    public void addEdge(int tail, int head) {
        this.addEdge(tail, head, ++this.edgeMaxIndex);
    }

    public void addComponent(int vertex, Set<V> vertices) {
        this.addVertex(vertex);
        this.map.put(vertex, vertices);
    }

    public Set<V> getComponent(int vertex) {
        return this.map.get(vertex);
    }

    public Set<Integer> getSources() {
        TreeSet<Integer> sources = new TreeSet<Integer>();
        for (Integer i : this.vertexSet()) {
            Iterator it = this.incomingEdgesOf(i).iterator();
            if (it.hasNext()) continue;
            sources.add(i);
        }
        return sources;
    }

    public Set<Integer> getSinks() {
        TreeSet<Integer> sinks = new TreeSet<Integer>();
        for (Integer i : this.vertexSet()) {
            Iterator it = this.outgoingEdgesOf(i).iterator();
            if (it.hasNext()) continue;
            sinks.add(i);
        }
        return sinks;
    }

    public int getNbrComponents() {
        return this.vertexSet().size();
    }

    public int[] computeLayers(Iterable<Integer> sources, boolean direction) {
        Iterable<Integer> firstLayer = sources;
        int size = 0;
        Iterator it = this.vertexSet().iterator();
        while (it.hasNext()) {
            it.next();
            ++size;
        }
        int[] layers = new int[size];
        for (int i = 0; i < size; ++i) {
            layers[i] = -1;
        }
        for (int i : firstLayer) {
            layers[i] = 0;
            this.computeLayersRec(i, layers, 1, direction);
        }
        return layers;
    }

    private void computeLayersRec(int v, int[] layers, int actualLayer, boolean direction) {
        Set it = null;
        it = direction ? this.outgoingEdgesOf(v) : this.incomingEdgesOf(v);
        Iterator iterator = it.iterator();
        while (iterator.hasNext()) {
            int s = (Integer)iterator.next();
            int succ = direction ? ((Integer)this.getEdgeTarget(s)).intValue() : ((Integer)this.getEdgeSource(s)).intValue();
            if (layers[succ] >= actualLayer || v == succ) continue;
            layers[succ] = actualLayer;
            this.computeLayersRec(succ, layers, actualLayer + 1, direction);
        }
    }
}

