/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.stream;

import fr.lirmm.graphik.util.stream.AbstractCloseableIterator;
import fr.lirmm.graphik.util.stream.InMemoryStream;
import java.util.Iterator;

public class ArrayBlockingStream<T>
extends AbstractCloseableIterator<T>
implements InMemoryStream<T> {
    final int MIN_QUEUE;
    private final Object[] buffer;
    private final Object lock;
    private boolean isOpen = true;
    private int writeIndex = 0;
    private int readIndex = 0;
    private int size = 0;

    public ArrayBlockingStream(int bufferSize) {
        this.buffer = new Object[bufferSize];
        this.MIN_QUEUE = bufferSize / 3;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(T object) {
        Object object2 = this.lock;
        synchronized (object2) {
            while (this.isOpen && this.size == this.buffer.length) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.buffer[this.writeIndex] = object;
            ++this.size;
            this.writeIndex = (this.writeIndex + 1) % this.buffer.length;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Object object = this.lock;
        synchronized (object) {
            while (this.isOpen && this.size == 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.size > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T next() {
        Object object = this.lock;
        synchronized (object) {
            this.hasNext();
            Object object2 = this.buffer[this.readIndex];
            --this.size;
            this.readIndex = (this.readIndex + 1) % this.buffer.length;
            if (this.size == this.MIN_QUEUE) {
                this.lock.notifyAll();
            }
            return (T)object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.isOpen = false;
            this.lock.notifyAll();
        }
    }

    @Override
    public void write(Iterator<T> it) {
        while (it.hasNext()) {
            this.write(it.next());
        }
    }
}

