/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.stream;

import fr.lirmm.graphik.util.stream.AbstractCloseableIterator;
import fr.lirmm.graphik.util.stream.Writer;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class LinkedBlockingStream<T>
extends AbstractCloseableIterator<T>
implements Writer<T> {
    final int MAX_QUEUE;
    final int MIN_QUEUE;
    private final Object lock;
    private final Queue<T> queue = new LinkedList<T>();
    private boolean isOpen = true;

    public LinkedBlockingStream() {
        this.MAX_QUEUE = 1024;
        this.MIN_QUEUE = 32;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(T object) {
        Object object2 = this.lock;
        synchronized (object2) {
            while (this.isOpen && this.queue.size() >= this.MAX_QUEUE) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.queue.add(object);
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Object object = this.lock;
        synchronized (object) {
            while (this.isOpen && this.queue.size() == 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return !this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T next() {
        Object object = this.lock;
        synchronized (object) {
            this.hasNext();
            T object2 = this.queue.poll();
            if (this.queue.size() <= this.MIN_QUEUE) {
                this.lock.notifyAll();
            }
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.isOpen = false;
            this.lock.notifyAll();
        }
    }

    @Override
    public void write(Iterator<T> it) throws IOException {
        while (it.hasNext()) {
            this.write(it.next());
        }
    }
}

