/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.stream;

import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.Iterator;

public class UniqIterator<T>
implements CloseableIterator<T> {
    private CloseableIterator<T> it;
    private T previous;
    private T next;

    public UniqIterator(Iterator<T> it) {
        this.it = new CloseableIteratorAdapter<T>(it);
    }

    public UniqIterator(CloseableIterator<T> it) {
        this.it = it;
    }

    @Override
    public boolean hasNext() throws IteratorException {
        while (this.next == null && this.it.hasNext()) {
            T current = this.it.next();
            if (current.equals(this.previous)) continue;
            this.next = current;
        }
        return this.next != null;
    }

    @Override
    public T next() {
        this.previous = this.next;
        this.next = null;
        return this.previous;
    }

    @Override
    public void close() {
        this.it.close();
    }
}

