/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.stream.converter;

import fr.lirmm.graphik.util.stream.AbstractCloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import fr.lirmm.graphik.util.stream.IteratorException;
import fr.lirmm.graphik.util.stream.converter.ConversionException;
import fr.lirmm.graphik.util.stream.converter.Converter;
import java.util.Iterator;

public class ConverterCloseableIterator<U, T>
extends AbstractCloseableIterator<T> {
    private final CloseableIterator<U> it;
    private final Converter<U, T> converter;

    public ConverterCloseableIterator(CloseableIterator<U> it, Converter<U, T> converter) {
        this.converter = converter;
        this.it = it;
    }

    public ConverterCloseableIterator(Iterator<U> it, Converter<U, T> converter) {
        this((CloseableIterator<U>)new CloseableIteratorAdapter<U>(it), converter);
    }

    @Override
    public boolean hasNext() throws IteratorException {
        return this.it.hasNext();
    }

    @Override
    public T next() throws IteratorException {
        try {
            return this.converter.convert(this.it.next());
        }
        catch (ConversionException e) {
            throw new IteratorException(e);
        }
    }

    @Override
    public void close() {
        this.it.close();
    }
}

