/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.stream.filter;

import fr.lirmm.graphik.util.stream.AbstractCloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import fr.lirmm.graphik.util.stream.filter.Filter;

public class FilterCloseableIterator<U, T>
extends AbstractCloseableIterator<T> {
    private final CloseableIterator<U> it;
    private final Filter<U> filter;
    private T next;

    public FilterCloseableIterator(CloseableIterator<U> it, Filter<U> filter) {
        this.filter = filter;
        this.it = it;
        this.next = null;
    }

    @Override
    public boolean hasNext() throws IteratorException {
        while (this.next == null && this.it.hasNext()) {
            U o = this.it.next();
            if (!this.filter.filter(o)) continue;
            this.next = o;
        }
        return this.next != null;
    }

    @Override
    public T next() throws IteratorException {
        this.hasNext();
        T t = this.next;
        this.next = null;
        return t;
    }

    @Override
    public void close() {
        this.it.close();
    }
}

