/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.boreal.util;

import fr.boreal.model.logicalElements.api.Atom;
import fr.boreal.model.logicalElements.api.Substitution;
import fr.boreal.model.logicalElements.api.Term;
import fr.boreal.model.logicalElements.impl.SubstitutionImpl;
import java.util.HashMap;

public class AtomType {
    public static final int VARIABLE = -1;
    public static final int CONSTANT_OR_FROZEN_VAR = -2;
    private boolean theAtomContainsAConstant = false;
    private boolean multipleOccurrencesOfTheSameVariable;
    private int[] type;
    private int size;

    public AtomType(Atom atom) {
        this(atom, (Substitution)new SubstitutionImpl());
    }

    public AtomType(Atom atom, Substitution s) {
        this.size = atom.getPredicate().getArity();
        this.type = new int[this.size];
        HashMap<Term, Integer> firstPositionMap = new HashMap<Term, Integer>();
        for (int i = 0; i < atom.getPredicate().getArity(); ++i) {
            Term t = atom.getTerm(i);
            if (t.isFrozen(s)) {
                this.type[i] = -2;
                this.theAtomContainsAConstant = true;
                this.multipleOccurrencesOfTheSameVariable = true;
                continue;
            }
            Integer firstPos = (Integer)firstPositionMap.get(t);
            if (firstPos == null) {
                firstPositionMap.put(t, i);
                firstPos = -1;
            } else {
                this.multipleOccurrencesOfTheSameVariable = true;
            }
            this.type[i] = firstPos;
        }
    }

    public int getType(int index) {
        return this.type[index];
    }

    public boolean isThereConstant() {
        return this.theAtomContainsAConstant;
    }

    public boolean isThereConstraint() {
        return this.multipleOccurrencesOfTheSameVariable;
    }
}

