/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.boreal.util;

import fr.boreal.model.logicalElements.api.Atom;
import fr.boreal.model.logicalElements.api.Term;
import fr.boreal.model.logicalElements.api.Variable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class PiecesSplitter {
    private boolean includeGroundedAtoms;
    private Collection<Variable> existentialVariables;

    public PiecesSplitter() {
        this(true);
    }

    public PiecesSplitter(boolean includeGroundedAtoms) {
        this(includeGroundedAtoms, null);
    }

    public PiecesSplitter(boolean includeGroundedAtoms, Collection<Variable> existentialVariables) {
        this.includeGroundedAtoms = includeGroundedAtoms;
        this.existentialVariables = existentialVariables;
    }

    public Collection<Collection<Atom>> split(Collection<Atom> toSplit) {
        ArrayList<Collection<Atom>> pieces = new ArrayList<Collection<Atom>>();
        if (this.existentialVariables == null) {
            this.existentialVariables = new HashSet<Variable>();
            toSplit.forEach(atom -> this.existentialVariables.addAll(atom.getVariables()));
        }
        Collection<Variable> variables = this.existentialVariables;
        HashSet<Variable> varToTreat = new HashSet<Variable>();
        varToTreat.addAll(variables);
        while (!varToTreat.isEmpty()) {
            Variable root = (Variable)varToTreat.iterator().next();
            ArrayDeque<Variable> queue = new ArrayDeque<Variable>();
            queue.add(root);
            HashSet<Atom> piece = new HashSet<Atom>();
            while (!queue.isEmpty()) {
                Variable v2 = (Variable)queue.pollFirst();
                varToTreat.remove(v2);
                for (Atom a : toSplit) {
                    if (!a.contains((Term)v2)) continue;
                    a.getVariables().stream().filter(vv -> variables.contains(vv) && varToTreat.contains(vv)).distinct().forEach(vv -> {
                        queue.add((Variable)vv);
                        varToTreat.remove(vv);
                    });
                    piece.add(a);
                }
            }
            pieces.add(piece);
        }
        if (this.includeGroundedAtoms) {
            for (Atom a : toSplit) {
                long nbVar = a.getVariables().stream().filter(v -> variables.contains(v)).distinct().count();
                if (nbVar != 0L) continue;
                HashSet<Atom> atomSet = new HashSet<Atom>();
                atomSet.add(a);
                pieces.add(atomSet);
            }
        }
        return pieces;
    }
}

